/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.mixin;

import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import net.yirmiri.dungeonsdelight.core.registry.DDEffects;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDSounds;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin {
    @Unique
    private static Random random = new Random();
    @Unique
    Player player = (Player)this;
    LivingEntity living = (LivingEntity)this;
    private int dashCount = 0;
    private byte recentlyDashed = 0;

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void dungeonsdelight$tick(CallbackInfo ci) {
        if (!this.player.hasEffect(DDEffects.SWIFT_STEP)) {
            this.dashCount = 0;
            this.recentlyDashed = 0;
        }
        if (this.player.hasEffect(DDEffects.SWIFT_STEP)) {
            if (this.player.onGround()) {
                this.dashCount = this.player.getEffect(DDEffects.SWIFT_STEP).getAmplifier() + 1;
            }
            if (this.player.getDeltaMovement().y < 0.0 && this.player.isShiftKeyDown() && this.recentlyDashed == 0 && !this.player.getAbilities().flying && this.dashCount > 0 && !this.player.onClimbable() && !this.player.onGround()) {
                double d = this.player.getX();
                double e = this.player.getY() + (double)(this.player.getBbHeight() / 2.0f);
                double f = this.player.getZ();
                this.player.level().explode((Entity)this.player, null, AbstractWindCharge.EXPLOSION_DAMAGE_CALCULATOR, d, e, f, 4.0f + (float)this.player.getEffect(DDEffects.SWIFT_STEP).getAmplifier() / 2.0f, false, Level.ExplosionInteraction.TRIGGER, (ParticleOptions)ParticleTypes.GUST_EMITTER_SMALL, (ParticleOptions)ParticleTypes.GUST_EMITTER_LARGE, (Holder)SoundEvents.WIND_CHARGE_BURST);
                DDUtil.knockbackNearbyEntities(this.player.level(), (LivingEntity)this.player, (Entity)this.living);
                DDUtil.dash(this.player);
                --this.dashCount;
                if (this.player.hasEffect(DDEffects.RAVENOUS_RUSH)) {
                    this.recentlyDashed = (byte)10;
                } else {
                    this.recentlyDashed = (byte)20;
                    this.player.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 100, 0, true, false, true));
                }
            }
        }
        if (this.recentlyDashed > 0) {
            this.recentlyDashed = (byte)(this.recentlyDashed - 1);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"})
    private void dungeonsdelight$hurt(DamageSource source, float amount, CallbackInfoReturnable<Boolean> cir) {
        if (this.player.hasEffect(DDEffects.EXUDATION) && this.player.getAbsorptionAmount() > 0.0f && this.player.hurtTime == 0 && !this.player.getAbilities().invulnerable) {
            if (this.player.level() instanceof ServerLevel) {
                ((ServerLevel)this.player.level()).sendParticles((ParticleOptions)DDParticles.SKULL_HEART_BLAST.get(), this.player.getX(), this.player.getY() + 0.5, this.player.getZ(), 0, 0.0, 0.0, 0.0, 0.0);
            }
            this.player.level().playSound(null, this.player.getX(), this.player.getY(), this.player.getZ(), SoundEvents.WARDEN_SONIC_BOOM, SoundSource.NEUTRAL, 0.75f, 2.0f);
            DDUtil.skullHeartBlast(this.player.level(), (LivingEntity)this.player, (Entity)this.player);
            this.player.hurtTime = 30;
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"attack"})
    public void dungeonsdelight$attack(Entity entity, CallbackInfo ci) {
        if (this.player.hasEffect(DDEffects.DECISIVE)) {
            float amount = (float)this.player.getAttributeValue(Attributes.ATTACK_DAMAGE);
            double decisiveLevel = this.player.getEffect(DDEffects.DECISIVE).getAmplifier();
            DamageSource source = this.player.damageSources().playerAttack(this.player);
            if (20.0 + decisiveLevel != 0.0 && random.nextDouble(100.0) < 20.0 + decisiveLevel && this.player.isAlive()) {
                entity.hurt(source, amount * 1.75f);
                entity.playSound(DDSounds.DECISIVE_CRIT.get(), 1.0f, 1.0f);
                DDUtil.spreadParticles((ParticleOptions)DDParticles.DECISIVE_CRITICAL.get(), entity, random);
                if (this.player.hasEffect(DDEffects.VORACITY)) {
                    this.player.addEffect(new MobEffectInstance(DDEffects.RAVENOUS_RUSH, this.player.getEffect(DDEffects.VORACITY).getDuration() + 60, 0));
                }
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isHurt"}, cancellable=true)
    private void dungeonsdelight$canFoodHeal(CallbackInfoReturnable<Boolean> cir) {
        if (this.player.hasEffect(DDEffects.TENACITY)) {
            cir.setReturnValue((Object)false);
        }
    }
}

