/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.core.event;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.particle.BubblePopParticle;
import net.minecraft.client.particle.CampfireSmokeParticle;
import net.minecraft.client.particle.CritParticle;
import net.minecraft.client.particle.FlameParticle;
import net.minecraft.client.particle.SonicBoomParticle;
import net.minecraft.client.particle.SoulParticle;
import net.minecraft.client.particle.SpellParticle;
import net.minecraft.client.particle.SuspendedTownParticle;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.CampfireRenderer;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.yirmiri.dungeonsdelight.common.block.entity.DungeonStoveBlockEntityRenderer;
import net.yirmiri.dungeonsdelight.common.block.entity.ItemGrateBlockEntityRenderer;
import net.yirmiri.dungeonsdelight.common.block.monster_pot.MonsterPotRecipe;
import net.yirmiri.dungeonsdelight.common.block.monster_pot.MonsterPotRecipeBookTab;
import net.yirmiri.dungeonsdelight.common.block.monster_pot.MonsterPotRecipeCategories;
import net.yirmiri.dungeonsdelight.common.block.monster_pot.MonsterPotScreen;
import net.yirmiri.dungeonsdelight.common.entity.misc.CleaverEntityRenderer;
import net.yirmiri.dungeonsdelight.common.entity.misc.EmptyEntityRenderer;
import net.yirmiri.dungeonsdelight.common.entity.misc.GunkArrowRenderer;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntityModel;
import net.yirmiri.dungeonsdelight.common.entity.monster_yam.MonsterYamEntityRenderer;
import net.yirmiri.dungeonsdelight.common.entity.zombified_dryad.ZombifiedDryadRenderer;
import net.yirmiri.dungeonsdelight.common.particle.EchoBlastParticle;
import net.yirmiri.dungeonsdelight.common.particle.FlameEffectParticle;
import net.yirmiri.dungeonsdelight.core.init.DDBlockSetTypes;
import net.yirmiri.dungeonsdelight.core.init.DDModelLayers;
import net.yirmiri.dungeonsdelight.core.registry.DDBlockEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDBlocks;
import net.yirmiri.dungeonsdelight.core.registry.DDEntities;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;
import net.yirmiri.dungeonsdelight.core.registry.DDMenuTypes;
import net.yirmiri.dungeonsdelight.core.registry.DDParticles;
import net.yirmiri.dungeonsdelight.core.registry.DDRecipeRegistries;

@EventBusSubscriber(modid="dungeonsdelight", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class DDClientEvents {
    public static final EnumProxy<RecipeBookCategories> PROXY_MONSTER_SEARCH = new EnumProxy(RecipeBookCategories.class, new Object[]{() -> List.of(new ItemStack((ItemLike)Items.COMPASS))});
    public static final EnumProxy<RecipeBookCategories> PROXY_MONSTER_MEALS = new EnumProxy(RecipeBookCategories.class, new Object[]{() -> List.of(new ItemStack((ItemLike)DDItems.GHOULASH.get()))});
    public static final EnumProxy<RecipeBookCategories> PROXY_MONSTER_DRINKS = new EnumProxy(RecipeBookCategories.class, new Object[]{() -> List.of(new ItemStack((ItemLike)DDItems.TARO_MILK_TEA.get()))});
    public static final EnumProxy<RecipeBookCategories> PROXY_MONSTER_MISC = new EnumProxy(RecipeBookCategories.class, new Object[]{() -> List.of(new ItemStack((ItemLike)DDItems.MONSTER_MUFFIN.get()), new ItemStack((ItemLike)DDItems.WARDENZOLA_CRUMBLES.get()))});

    @SubscribeEvent
    public static void registerBlockRenderLayers(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.MONSTER_POT.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.ROTTEN_CROP.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.ROTTEN_POTATOES.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.ROTTEN_TOMATOES.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.LIVING_TORCH.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.WALL_LIVING_TORCH.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.LIVING_CAMPFIRE.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.LIVING_LANTERN.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.WORMROOT_TENDRILS.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.GUNK.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.GUARDIAN_ANGEL_BLOCK.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.CANDLE_MONSTER_CAKE.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.STAINED_SCRAP_GRATE.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.SILVERFISH_AND_CHIPS_BLOCK.get(), (RenderType)RenderType.cutout());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.WORMWOOD_DOOR.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.WORMWOOD_TRAPDOOR.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.ROTBULB_PLANT.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.ROTBULB_CROP.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.STAINED_SCRAP_BARS.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.LIVING_FIRE.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.ROTTEN_SPAWNER.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.STAINED_SCRAP_DOOR.get(), (RenderType)RenderType.cutoutMipped());
        ItemBlockRenderTypes.setRenderLayer((Block)DDBlocks.STAINED_SCRAP_TRAPDOOR.get(), (RenderType)RenderType.cutoutMipped());
    }

    @SubscribeEvent
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)DDParticles.LIVING_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.SPIRIT_FLAME.get(), FlameParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.DUNGEON_BUBBLE.get(), BubblePopParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.SKULL_HEART_BLAST.get(), SonicBoomParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.DECISIVE_CRITICAL.get(), CritParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.ROTTEN_GLINT.get(), SuspendedTownParticle.HappyVillagerProvider::new);
        event.registerSpriteSet((ParticleType)DDParticles.MONSTER_SMOKE.get(), CampfireSmokeParticle.CosyProvider::new);
        event.registerSpriteSet((ParticleType)DDParticles.MONSTER_STEAM.get(), CampfireSmokeParticle.CosyProvider::new);
        event.registerSpriteSet((ParticleType)DDParticles.ROT_CLOUD.get(), SuspendedTownParticle.HappyVillagerProvider::new);
        event.registerSpriteSet((ParticleType)DDParticles.SPIRIT.get(), SoulParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.LARGE_ECHO_BLAST.get(), EchoBlastParticle.Large::new);
        event.registerSpriteSet((ParticleType)DDParticles.MEDIUM_ECHO_BLAST.get(), EchoBlastParticle.Medium::new);
        event.registerSpriteSet((ParticleType)DDParticles.SMALL_ECHO_BLAST.get(), EchoBlastParticle.Small::new);
        event.registerSpriteSet((ParticleType)DDParticles.LIVING_FLAME_EFFECT.get(), FlameEffectParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.SPIRIT_FLAME_EFFECT.get(), FlameEffectParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.DECISIVE.get(), SpellParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.EXUDATION.get(), SpellParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.TENACITY.get(), SpellParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.VORACITY.get(), SpellParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.BURROW_GUT.get(), SpellParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.POUNCING.get(), SpellParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.SWIFT_STEP.get(), SpellParticle.Provider::new);
        event.registerSpriteSet((ParticleType)DDParticles.ROTGUT.get(), SpellParticle.Provider::new);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        Sheets.addWoodType((WoodType)DDBlockSetTypes.WORMWOOD);
    }

    @SubscribeEvent
    public static void registerMenuScreens(RegisterMenuScreensEvent event) {
        event.register(DDMenuTypes.MONSTER_POT.get(), MonsterPotScreen::new);
    }

    @SubscribeEvent
    public static void registerOverlays(RegisterGuiLayersEvent event) {
    }

    @SubscribeEvent
    public static void registerRenderLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(MonsterYamEntityModel.LAYER_LOC, MonsterYamEntityModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        Supplier<LayerDefinition> main = () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f), (int)64, (int)64);
        Supplier<LayerDefinition> outer = () -> LayerDefinition.create((MeshDefinition)HumanoidModel.createMesh((CubeDeformation)new CubeDeformation(0.25f), (float)0.0f), (int)64, (int)64);
        Supplier<LayerDefinition> innerArmor = () -> LayerDefinition.create((MeshDefinition)HumanoidArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION), (int)64, (int)32);
        Supplier<LayerDefinition> outerArmor = () -> LayerDefinition.create((MeshDefinition)HumanoidArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION), (int)64, (int)32);
        event.registerLayerDefinition(DDModelLayers.ZOMBIFIED_DRYAD, main);
        event.registerLayerDefinition(DDModelLayers.ZOMBIFIED_DRYAD_OUTER_LAYER, outer);
        event.registerLayerDefinition(DDModelLayers.ZOMBIFIED_DRYAD_INNER_ARMOR, innerArmor);
        event.registerLayerDefinition(DDModelLayers.ZOMBIFIED_DRYAD_OUTER_ARMOR, outerArmor);
    }

    @SubscribeEvent
    public static void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(DDBlockEntities.DUNGEON_STOVE.get(), DungeonStoveBlockEntityRenderer::new);
        event.registerBlockEntityRenderer(DDBlockEntities.LIVING_CAMPFIRE.get(), CampfireRenderer::new);
        event.registerBlockEntityRenderer(DDBlockEntities.ITEM_GRATE.get(), ItemGrateBlockEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(DDEntities.ANCIENT_EGG.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(DDEntities.CLEAVER.get(), CleaverEntityRenderer::new);
        event.registerEntityRenderer(DDEntities.MONSTER_YAM.get(), MonsterYamEntityRenderer::new);
        event.registerEntityRenderer(DDEntities.RANCID_REDUCTION.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer(DDEntities.GUNK_ARROW.get(), GunkArrowRenderer::new);
        event.registerEntityRenderer(DDEntities.ZOMBIFIED_DRYAD.get(), ZombifiedDryadRenderer::new);
        event.registerEntityRenderer(DDEntities.ECHO_BLAST.get(), EmptyEntityRenderer::new);
    }

    @SubscribeEvent
    public static void registerRecipeBookCategories(RegisterRecipeBookCategoriesEvent event) {
        event.registerBookCategories(MonsterPotRecipeCategories.MONSTER_COOKING, (List)ImmutableList.of((Object)MonsterPotRecipeCategories.MONSTER_SEARCH, (Object)MonsterPotRecipeCategories.MONSTER_MEALS, (Object)MonsterPotRecipeCategories.MONSTER_DRINKS, (Object)MonsterPotRecipeCategories.MONSTER_MISC));
        event.registerAggregateCategory(MonsterPotRecipeCategories.MONSTER_SEARCH, (List)ImmutableList.of((Object)MonsterPotRecipeCategories.MONSTER_MEALS, (Object)MonsterPotRecipeCategories.MONSTER_DRINKS, (Object)MonsterPotRecipeCategories.MONSTER_MISC));
        event.registerRecipeCategoryFinder(DDRecipeRegistries.MONSTER_COOKING_RECIPE_TYPE.get(), recipe -> {
            Recipe patt0$temp = recipe.value();
            if (patt0$temp instanceof MonsterPotRecipe) {
                MonsterPotRecipe monsterPotRecipe = (MonsterPotRecipe)patt0$temp;
                MonsterPotRecipeBookTab tab = monsterPotRecipe.getRecipeBookTab();
                return switch (tab) {
                    default -> throw new MatchException(null, null);
                    case MonsterPotRecipeBookTab.MONSTER_MEALS -> MonsterPotRecipeCategories.MONSTER_MEALS;
                    case MonsterPotRecipeBookTab.MONSTER_DRINKS -> MonsterPotRecipeCategories.MONSTER_DRINKS;
                    case MonsterPotRecipeBookTab.MONSTER_MISC -> MonsterPotRecipeCategories.MONSTER_MISC;
                };
            }
            return null;
        });
    }
}

