/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.HugeExplosionParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SingleQuadParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public class EchoBlastParticle
extends HugeExplosionParticle {
    private final SpriteSet sprites;
    private final float maxSize;
    private final int maxLifetime;

    protected EchoBlastParticle(ClientLevel level, double x, double y, double z, float maxSize, int maxLifetime, SpriteSet sprites) {
        super(level, x, y, z, 0.0, sprites);
        this.sprites = sprites;
        this.maxSize = maxSize;
        this.maxLifetime = maxLifetime;
        this.lifetime = maxLifetime;
        this.quadSize = 0.0f;
        this.alpha = 1.0f;
        this.setSpriteFromAge(sprites);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
        this.setAlpha((float)((double)(1 - this.age) < 0.5 ? (double)(8 * this.age * this.age * this.age * this.age) : 1.0 - Math.pow(-2 * this.age + 2, 4.0) / (double)this.lifetime));
    }

    public SingleQuadParticle.FacingCameraMode getFacingCameraMode() {
        return SingleQuadParticle.FacingCameraMode.LOOKAT_XYZ;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void render(VertexConsumer buffer, Camera camera, float pPartialTicks) {
        Quaternionf quaternionf = new Quaternionf();
        this.getFacingCameraMode().setRotation(quaternionf, camera, pPartialTicks);
        if (this.roll != 0.0f) {
            quaternionf.rotateZ(Mth.lerp((float)pPartialTicks, (float)this.oRoll, (float)this.roll));
        }
        this.quadSize += ((float)this.age + pPartialTicks) / (float)this.lifetime * 0.24f;
        quaternionf.rotationXYZ(-1.5707964f, 0.0f, 0.0f);
        this.renderRotatedQuad(buffer, camera, quaternionf, pPartialTicks);
    }

    public static class Large
    extends Provider {
        private final SpriteSet sprites;

        public Large(SpriteSet sprites) {
            super(sprites);
            this.sprites = sprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EchoBlastParticle(level, x, y + 0.5, z, 4.0f, 32, this.sprites);
        }
    }

    public static class Medium
    extends Provider {
        private final SpriteSet sprites;

        public Medium(SpriteSet sprites) {
            super(sprites);
            this.sprites = sprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EchoBlastParticle(level, x, y + 0.5, z, 3.0f, 24, this.sprites);
        }
    }

    public static class Small
    extends Provider {
        private final SpriteSet sprites;

        public Small(SpriteSet sprites) {
            super(sprites);
            this.sprites = sprites;
        }

        @Override
        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EchoBlastParticle(level, x, y + 0.5, z, 2.0f, 16, this.sprites);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EchoBlastParticle(level, x, y + 0.5, z, 2.5f, 20, this.sprites);
        }
    }
}

