/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.item.food_type.UndeadFoodItem;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class SculkUndeadFoodItem
extends UndeadFoodItem {
    private final boolean hasFoodEffectTooltip;
    private final int level;

    public SculkUndeadFoodItem(Item.Properties properties, int level, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.level = level;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        super.finishUsingItem(stack, level, living);
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            switch (this.level) {
                case 1: {
                    DDUtil.echoBlastSmall(level, (LivingEntity)player);
                    break;
                }
                case 2: {
                    DDUtil.echoBlastMedium(level, (LivingEntity)player);
                    break;
                }
                case 3: {
                    DDUtil.echoBlastLarge(level, (LivingEntity)player);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + this.level);
                }
            }
        }
        return stack;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            String translationKey = "tooltip.undead.sculk_level_" + this.level;
            tooltip.add((Component)TextUtils.getTranslation((String)translationKey, (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            if (this.hasFoodEffectTooltip) {
                Objects.requireNonNull(tooltip);
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)ctx.tickRate());
            }
        }
    }
}

