/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food_type;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.util.DDUtil;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class CurativeFoodItem
extends ConsumableItem {
    private final boolean hasFoodEffectTooltip;
    private final float chance;

    public CurativeFoodItem(Item.Properties properties, float chance, boolean hasFoodEffectTooltip) {
        super(properties, hasFoodEffectTooltip, false);
        this.hasFoodEffectTooltip = hasFoodEffectTooltip;
        this.chance = chance;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity living) {
        if (!level.isClientSide && living instanceof Player) {
            Player player = (Player)living;
            for (int i = 0; i < DDUtil.MONSTER_EFFECTS.size(); ++i) {
                if (!player.hasEffect(DDUtil.MONSTER_EFFECTS.get(i))) continue;
                DDUtil.applyCureEffectSwap((LivingEntity)player, DDUtil.MONSTER_EFFECTS.get(i), DDUtil.NORMAL_EFFECTS.get(i));
                break;
            }
        }
        super.finishUsingItem(stack, level, living);
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, ctx, tooltip, isAdvanced);
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            int percent = Math.round(this.chance * 100.0f);
            tooltip.add((Component)Component.literal((String)(percent + "% ")).append((Component)Component.translatable((String)"farmersdelight.tooltip.chance_to_cure")).withStyle(ChatFormatting.BLUE));
        }
    }
}

