/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.yirmiri.dungeonsdelight.common.item.food_type.LengthConsumableItem;
import net.yirmiri.dungeonsdelight.core.registry.DDItems;

public class RockCandyItem
extends LengthConsumableItem {
    public RockCandyItem(Item.Properties properties) {
        super(properties, 48, true, false);
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Silverfish silverfishEntity;
        Vex vexEntity;
        super.hurtEnemy(stack, target, attacker);
        if (target instanceof Vex && (vexEntity = (Vex)target).isAlive() && !((Player)attacker).getCooldowns().isOnCooldown((Item)this)) {
            vexEntity.level().playSound((Player)attacker, (Entity)vexEntity, SoundEvents.VEX_DEATH, SoundSource.HOSTILE, 1.0f, 1.0f);
            vexEntity.remove(Entity.RemovalReason.DISCARDED);
            if (!attacker.level().isClientSide) {
                if (stack.isEmpty()) {
                    new ItemStack((ItemLike)DDItems.CANDIED_VEX_SUCKER.get());
                } else {
                    if (attacker instanceof Player) {
                        ItemStack itemStack = new ItemStack((ItemLike)DDItems.CANDIED_VEX_SUCKER.get());
                        Player inventory = (Player)attacker;
                        if (!inventory.getInventory().add(itemStack)) {
                            inventory.drop(itemStack, false);
                        }
                    }
                    ((Player)attacker).getCooldowns().addCooldown((Item)this, 40);
                    stack.shrink(1);
                }
            }
        } else if (target instanceof Silverfish && (silverfishEntity = (Silverfish)target).isAlive() && !((Player)attacker).getCooldowns().isOnCooldown((Item)this)) {
            silverfishEntity.level().playSound((Player)attacker, (Entity)silverfishEntity, SoundEvents.SILVERFISH_DEATH, SoundSource.HOSTILE, 1.0f, 1.0f);
            silverfishEntity.remove(Entity.RemovalReason.DISCARDED);
            if (!attacker.level().isClientSide) {
                if (stack.isEmpty()) {
                    new ItemStack((ItemLike)DDItems.CANDIED_SILVERFISH_SUCKER.get());
                } else {
                    if (attacker instanceof Player) {
                        ItemStack itemStack = new ItemStack((ItemLike)DDItems.CANDIED_SILVERFISH_SUCKER.get());
                        Player inventory = (Player)attacker;
                        if (!inventory.getInventory().add(itemStack)) {
                            inventory.drop(itemStack, false);
                        }
                    }
                    ((Player)attacker).getCooldowns().addCooldown((Item)this, 40);
                    stack.shrink(1);
                }
            }
        }
        return true;
    }
}

