/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.item.food;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.yirmiri.dungeonsdelight.common.item.food_type.BiteableItem;
import vectorwing.farmersdelight.common.Configuration;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class BubblegunkItem
extends BiteableItem {
    private final int hungerReduction;
    private final boolean hasFoodEffectTooltip;

    public BubblegunkItem(Item.Properties properties, int stackSize, int hungerReduction, boolean hasPotionEffectTooltip) {
        super(properties, stackSize, hasPotionEffectTooltip);
        this.hungerReduction = hungerReduction;
        this.hasFoodEffectTooltip = hasPotionEffectTooltip;
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag isAdvanced) {
        if (((Boolean)Configuration.FOOD_EFFECT_TOOLTIP.get()).booleanValue()) {
            tooltip.add((Component)TextUtils.getTranslation((String)"tooltip.bubblegunk", (Object[])new Object[0]).withStyle(ChatFormatting.BLUE));
            if (this.hasFoodEffectTooltip) {
                TextUtils.addFoodEffectTooltip((ItemStack)stack, tooltip::add, (float)1.0f, (float)ctx.tickRate());
            }
        }
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity consumer) {
        Player player;
        Player player2 = player = consumer instanceof Player ? (Player)consumer : null;
        if (player != null) {
            int totalReduction = player.isCrouching() ? 2 : this.hungerReduction;
            new Thread(() -> {
                for (int i = 0; i < totalReduction; ++i) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException trace) {
                        trace.printStackTrace();
                    }
                    int currentFood = player.getFoodData().getFoodLevel();
                    player.getFoodData().setFoodLevel(Math.max(currentFood - 1, 0));
                }
            }).start();
        }
        return super.finishUsingItem(stack, level, consumer);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 24;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_BLOCK_STEP;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_BLOCK_STEP;
    }
}

