/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.effect;

import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class TenacityEffect
extends MobEffect {
    private final Holder<MobEffect> normalVariant;
    int applyInterval = 20;

    public TenacityEffect(Holder<MobEffect> normalVariant, MobEffectCategory category, int color, ParticleOptions particle) {
        super(category, color, particle);
        this.normalVariant = normalVariant;
    }

    public TenacityEffect(Holder<MobEffect> normalVariant, MobEffectCategory category, int color) {
        super(category, color);
        this.normalVariant = normalVariant;
    }

    public Component getDisplayName() {
        return Component.translatable((String)this.getDescriptionId()).withStyle(style -> style.withColor(13137346));
    }

    public void onEffectAdded(LivingEntity living, int amplifier) {
        if (!living.level().isClientSide && living instanceof Player) {
            Player player = (Player)living;
            this.applyInterval = TenacityEffect.getInterval(player);
        }
        super.onEffectAdded(living, amplifier);
    }

    public boolean applyEffectTick(LivingEntity living, int amplifier) {
        if (!living.level().isClientSide && living instanceof Player) {
            Player player = (Player)living;
            player.heal(1.0f);
            player.getFoodData().tick(player);
            this.applyInterval = TenacityEffect.getInterval(player);
        }
        return true;
    }

    public static int getInterval(Player player) {
        if (player.getFoodData().getFoodLevel() != 0) {
            return player.getFoodData().getFoodLevel() * 3;
        }
        return player.getFoodData().getFoodLevel() * 3 + 1;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % (this.applyInterval - amplifier * 2) == 0;
    }
}

