/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.yirmiri.dungeonsdelight.common.block.entity.LivingCampfireBlockEntity;
import net.yirmiri.dungeonsdelight.core.registry.DDBlockEntities;

public class LivingCampfireBlock
extends CampfireBlock {
    public LivingCampfireBlock(BlockBehaviour.Properties properties) {
        super(false, 1, properties);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (!entity.fireImmune() && ((Boolean)state.getValue((Property)CampfireBlock.LIT)).booleanValue() && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.totalExperience > 0 && player.hurtTime == 0 && player.isAlive() && !player.getAbilities().instabuild) {
                player.giveExperiencePoints(-3);
                player.playSound(SoundEvents.EXPERIENCE_ORB_PICKUP, 0.75f, -1.0f);
            }
        }
        super.entityInside(state, level, pos, entity);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LivingCampfireBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return (Boolean)state.getValue((Property)LIT) != false ? LivingCampfireBlock.createTickerHelper(type, DDBlockEntities.LIVING_CAMPFIRE.get(), CampfireBlockEntity::particleTick) : null;
        }
        return (Boolean)state.getValue((Property)LIT) != false ? LivingCampfireBlock.createTickerHelper(type, DDBlockEntities.LIVING_CAMPFIRE.get(), CampfireBlockEntity::cookTick) : LivingCampfireBlock.createTickerHelper(type, DDBlockEntities.LIVING_CAMPFIRE.get(), CampfireBlockEntity::cooldownTick);
    }
}

