/*
 * Decompiled with CFR 0.152.
 */
package net.yirmiri.dungeonsdelight.common.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.yirmiri.dungeonsdelight.common.block.entity.ItemGrateBlockEntity;
import net.yirmiri.dungeonsdelight.common.block.entity.ItemGrateTooltip;
import net.yirmiri.dungeonsdelight.core.registry.DDBlockEntities;

public class ItemGrateBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<ItemGrateBlock> CODEC = ItemGrateBlock.simpleCodec(ItemGrateBlock::new);

    public ItemGrateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends ItemGrateBlock> codec() {
        return CODEC;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext ctx) {
        EntityCollisionContext entityCtx;
        Entity entity;
        if (ctx instanceof EntityCollisionContext && (entity = (entityCtx = (EntityCollisionContext)ctx).getEntity()) instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            entity = worldIn.getBlockEntity(pos);
            if (entity instanceof ItemGrateBlockEntity) {
                ItemGrateBlockEntity itemGrateBlockEntity = (ItemGrateBlockEntity)entity;
                if (itemEntity.getItem().is(itemGrateBlockEntity.getStack().getItem()) || itemGrateBlockEntity.canInsert()) {
                    return Shapes.empty();
                }
            }
        }
        return super.getCollisionShape(state, worldIn, pos, ctx);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ItemGrateBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ItemGrateBlockEntity) {
                ItemGrateBlockEntity itemGrateBlockEntity = (ItemGrateBlockEntity)blockEntity;
                itemGrateBlockEntity.dropItem(level, pos);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, pos, state1, blockEntity) -> {
            ItemGrateBlockEntity itemGrateBlockEntity;
            if (type == DDBlockEntities.ITEM_GRATE.get() && blockEntity instanceof ItemGrateBlockEntity && !(itemGrateBlockEntity = (ItemGrateBlockEntity)blockEntity).isWaxed()) {
                itemGrateBlockEntity.tick(pos);
            }
        };
    }

    private void addEnhancement(boolean tool, ItemStack stack, SoundEvent soundEvent, Player player) {
        player.playSound(soundEvent, 1.0f, 1.0f);
        if (!tool) {
            stack.shrink(1);
        } else {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack heldStack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof ItemGrateBlockEntity) {
            ItemGrateBlockEntity itemGrateBlockEntity = (ItemGrateBlockEntity)blockEntity;
            if (!player.isCrouching()) {
                if (player.getItemInHand(hand).isEmpty() && !itemGrateBlockEntity.canInsert()) {
                    itemGrateBlockEntity.takeItem(player);
                    return ItemInteractionResult.CONSUME;
                }
                if (itemGrateBlockEntity.canInsert()) {
                    itemGrateBlockEntity.insertItem(player, hand);
                    return ItemInteractionResult.SUCCESS;
                }
            }
            if (!itemGrateBlockEntity.canInsert()) {
                if (heldStack.is(Items.GLOWSTONE_DUST) && !itemGrateBlockEntity.isLarge()) {
                    itemGrateBlockEntity.setLarge(true);
                    this.addEnhancement(false, heldStack, SoundEvents.POWDER_SNOW_PLACE, player);
                }
                if (heldStack.is(ItemTags.AXES) && (itemGrateBlockEntity.isWaxed() || itemGrateBlockEntity.isFast() || itemGrateBlockEntity.isLarge())) {
                    itemGrateBlockEntity.setWaxed(false);
                    itemGrateBlockEntity.setFast(false);
                    itemGrateBlockEntity.setLarge(false);
                    this.addEnhancement(true, heldStack, SoundEvents.AXE_SCRAPE, player);
                }
                if (!itemGrateBlockEntity.isWaxed()) {
                    if (heldStack.is(Items.HONEYCOMB)) {
                        itemGrateBlockEntity.setWaxed(true);
                        this.addEnhancement(false, heldStack, SoundEvents.HONEYCOMB_WAX_ON, player);
                    }
                    if (heldStack.is(Items.REDSTONE) && !itemGrateBlockEntity.isFast()) {
                        itemGrateBlockEntity.setFast(true);
                        this.addEnhancement(false, heldStack, SoundEvents.POWDER_SNOW_PLACE, player);
                    }
                }
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        ItemGrateTooltip.appendHoverText(tooltipComponents);
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.is((Block)this) || super.skipRendering(state, adjacentBlockState, side);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        super.createBlockStateDefinition(stateBuilder);
        stateBuilder.add(new Property[]{WATERLOGGED, FACING});
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

