/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.item;

import com.tom.storagemod.Content;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.components.TagFilterComponent;
import com.tom.storagemod.inventory.filter.ItemFilter;
import com.tom.storagemod.inventory.filter.TagFilter;
import com.tom.storagemod.item.IItemFilter;
import com.tom.storagemod.menu.TagItemFilterMenu;
import com.tom.storagemod.util.BlockFaceReference;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TagFilterItem
extends Item
implements IItemFilter {
    public TagFilterItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("tag_item_filter", tooltip, new Object[0]);
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.item_filter.contents"));
            TagFilterComponent c = (TagFilterComponent)itemStack.get(Content.tagFilterComponent.get());
            boolean allow = false;
            ArrayList<MutableComponent> elems = new ArrayList<MutableComponent>();
            if (c != null) {
                for (TagKey<Item> s : c.tags()) {
                    elems.add(Component.translatable((String)"tooltip.toms_storage.item_filter.prefix", (Object[])new Object[]{s.location().toString()}));
                }
                allow = c.allowList();
            }
            if (elems.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.item_filter.no_items"));
            } else {
                tooltip.addAll(elems);
            }
            tooltip.add((Component)Component.translatable((String)(allow ? "tooltip.toms_storage.allowList" : "tooltip.toms_storage.denyList")));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.toms_storage.hold_control_for_details", (Object[])new Object[]{Minecraft.ON_OSX ? "CMD" : "CTRL"}).withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
        }
    }

    @Override
    public ItemFilter createFilter(BlockFaceReference face, ItemStack stack) {
        return new TagFilter(stack);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack is = player.getItemInHand(hand);
        this.openGui(is, player, () -> player.getItemInHand(hand).getItem() == this, null);
        return InteractionResultHolder.sidedSuccess((Object)is, (boolean)world.isClientSide);
    }

    @Override
    public void openGui(ItemStack is, Player player, BooleanSupplier isValid, Runnable refresh) {
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, pi, pl) -> new TagItemFilterMenu(id, pi, new TagFilter(is), isValid, refresh), is.getHoverName()));
    }
}

