/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;

public class StoredItemStack {
    private ItemStack stack;
    private long count;
    private int hash;
    private boolean hashZero;

    public StoredItemStack(ItemStack stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    public StoredItemStack(ItemStack stack) {
        this.stack = stack.copy();
        this.stack.setCount(1);
        this.count = stack.getCount();
    }

    public StoredItemStack(ItemStack stack, long count, int hash) {
        this.stack = stack;
        this.count = count;
        this.hash = hash;
        if (hash == 0) {
            this.hashZero = true;
        }
    }

    public StoredItemStack(StoredItemStack st) {
        this.stack = st.stack;
        this.count = st.count;
        this.hash = st.hash;
        this.hashZero = st.hashZero;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public long getQuantity() {
        return this.count;
    }

    public ItemStack getActualStack() {
        ItemStack s = this.stack.copy();
        s.setCount((int)this.count);
        return s;
    }

    public int hashCode() {
        if (this.hash == 0 && !this.hashZero) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.stack == null ? 0 : this.stack.getItem().hashCode());
            this.hash = result = 31 * result + (this.stack == null ? 0 : this.stack.getComponentsPatch().hashCode());
            if (this.hash == 0) {
                this.hashZero = true;
            }
            return result;
        }
        return this.hash;
    }

    public String getDisplayName() {
        return this.stack.getHoverName().getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredItemStack other = (StoredItemStack)obj;
        return !(this.stack == null ? other.stack != null : !ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack));
    }

    public boolean equals(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack));
    }

    public boolean equalItem(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !ItemStack.isSameItemSameComponents((ItemStack)this.stack, (ItemStack)other.stack));
    }

    public void grow(long c) {
        this.count += c;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public int getMaxStackSize() {
        return this.stack.getMaxStackSize();
    }

    public static StoredItemStack merge(StoredItemStack a, StoredItemStack b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return new StoredItemStack(a.stack, a.count + b.count, a.hashCode());
    }

    public boolean equalDetails(StoredItemStack pc) {
        return pc.count == this.count;
    }

    public static enum SortingTypes {
        AMOUNT(ComparatorAmount::new),
        NAME(ComparatorName::new),
        BY_MOD(ComparatorModName::new);

        public static final SortingTypes[] VALUES;
        private final Function<Boolean, IStoredItemStackComparator> factory;

        private SortingTypes(Function<Boolean, IStoredItemStackComparator> factory) {
            this.factory = factory;
        }

        public IStoredItemStackComparator create(boolean rev) {
            return this.factory.apply(rev);
        }

        static {
            VALUES = SortingTypes.values();
        }
    }

    public static interface IStoredItemStackComparator
    extends Comparator<StoredItemStack> {
        public boolean isReversed();

        public void setReversed(boolean var1);

        public int type();
    }

    public static class ComparatorModName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorModName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            String m1 = BuiltInRegistries.ITEM.getKey((Object)in1.getStack().getItem()).getNamespace();
            String m2 = BuiltInRegistries.ITEM.getKey((Object)in2.getStack().getItem()).getNamespace();
            int c1 = m1.compareTo(m2);
            int c2 = in1.getDisplayName().compareTo(in2.getDisplayName());
            int c = c1 == 0 ? c2 : c1;
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }

        @Override
        public int type() {
            return 2;
        }
    }

    public static class ComparatorName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in1.getDisplayName().compareTo(in2.getDisplayName());
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }

    public static class ComparatorAmount
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorAmount(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in2.getQuantity() > in1.getQuantity() ? 1 : (in1.getQuantity() == in2.getQuantity() ? in1.getStack().getHoverName().getString().compareTo(in2.getStack().getHoverName().getString()) : -1);
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }
}

