/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.item.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import mrtjp.projectred.exploration.init.ExplorationDataComponents;
import mrtjp.projectred.exploration.inventory.BackpackInventory;
import net.covers1624.quack.collection.FastStream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public class BackpackDataComponent
implements TooltipProvider {
    private final List<ItemStack> items;
    private final boolean isOpened;
    private final int itemCount;
    public static final Codec<BackpackDataComponent> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Codec.list((Codec)ItemStack.OPTIONAL_CODEC).fieldOf("items").forGetter(b -> b.items), (App)Codec.BOOL.fieldOf("isOpened").forGetter(b -> b.isOpened)).apply((Applicative)builder, BackpackDataComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BackpackDataComponent> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, b -> b.items, (StreamCodec)ByteBufCodecs.BOOL, b -> b.isOpened, BackpackDataComponent::new);

    private BackpackDataComponent(List<ItemStack> items, boolean isOpened) {
        this.items = items;
        this.isOpened = isOpened;
        this.itemCount = (int)items.stream().filter(stack -> !stack.isEmpty()).count();
    }

    public boolean equals(Object o) {
        if (!(o instanceof BackpackDataComponent)) {
            return false;
        }
        BackpackDataComponent that = (BackpackDataComponent)o;
        return this.isOpened == that.isOpened && this.itemCount == that.itemCount && Objects.equals(this.items, that.items);
    }

    public int hashCode() {
        return Objects.hash(this.items, this.isOpened, this.itemCount);
    }

    @Nullable
    public static BackpackDataComponent getComponent(ItemStack stack) {
        return (BackpackDataComponent)stack.get(ExplorationDataComponents.BACKPACK_DATA_COMPONENT);
    }

    public static void setComponent(ItemStack stack, BackpackDataComponent component) {
        stack.set(ExplorationDataComponents.BACKPACK_DATA_COMPONENT, (Object)component);
    }

    public boolean isOpened() {
        return this.isOpened;
    }

    public List<ItemStack> getItemsCopy() {
        return FastStream.of(this.items).map(ItemStack::copy).toList();
    }

    public int getItemCount() {
        return this.itemCount;
    }

    public BackpackInventory createInventory() {
        return new BackpackInventory(this.getItemsCopy());
    }

    public BackpackDataComponent withOpenedState(boolean isOpened) {
        return this.isOpened == isOpened ? this : new BackpackDataComponent(this.items, isOpened);
    }

    public static BackpackDataComponent fromInventory(BackpackInventory inventory, boolean isOpened) {
        ArrayList itemsCopy = FastStream.of((Iterable)inventory.getItems()).map(ItemStack::copy).toList();
        return new BackpackDataComponent(itemsCopy, isOpened);
    }

    public static BackpackDataComponent getOrCreateComponent(ItemStack stack, int size, boolean isOpened) {
        BackpackDataComponent component = BackpackDataComponent.getComponent(stack);
        if (component == null) {
            List<ItemStack> items = Collections.nCopies(size, ItemStack.EMPTY);
            return new BackpackDataComponent(items, isOpened);
        }
        return component.withOpenedState(isOpened);
    }

    public void addToTooltip(Item.TooltipContext context, Consumer<Component> tooltip, TooltipFlag flag) {
        if (this.isOpened) {
            return;
        }
        tooltip.accept((Component)Component.literal((String)(this.itemCount + " / 27")).withStyle(ChatFormatting.GRAY));
    }
}

