/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.init;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import mrtjp.projectred.exploration.ProjectRedExploration;
import mrtjp.projectred.exploration.init.ExplorationBlocks;
import mrtjp.projectred.exploration.world.gen.ConfigFileControlledAddCarversBiomeModifier;
import mrtjp.projectred.exploration.world.gen.ConfigFileControlledAddFeaturesBiomeModifier;
import mrtjp.projectred.exploration.world.gen.MarbleCaveWorldCarver;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class ExplorationWorldFeatures {
    public static final String ID_MARBLE_CAVE_CARVER = "marble_cave";
    public static Supplier<WorldCarver<CaveCarverConfiguration>> MARBLE_CAVE_CARVER;
    public static Supplier<MapCodec<ConfigFileControlledAddCarversBiomeModifier>> ADD_CARVER_BIOME_MODIFIER_CODEC;
    public static Supplier<MapCodec<ConfigFileControlledAddFeaturesBiomeModifier>> ADD_FEATURES_BIOME_MODIFIER_CODEC;
    public static ResourceKey<ConfiguredWorldCarver<?>> MARBLE_CAVE_CONFIGURED_CARVER;
    public static ResourceKey<ConfiguredFeature<?, ?>> RUBY_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> SAPPHIRE_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> PERIDOT_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> ELECTROTINE_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> TIN_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<ConfiguredFeature<?, ?>> SILVER_ORE_CONFIGURED_FEATURE;
    public static ResourceKey<PlacedFeature> RUBY_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> SAPPHIRE_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> PERIDOT_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> ELECTROTINE_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> TIN_ORE_PLACED_FEATURE;
    public static ResourceKey<PlacedFeature> SILVER_ORE_PLACED_FEATURE;

    public static void register() {
        MARBLE_CAVE_CARVER = ProjectRedExploration.WORLD_CARVERS.register(ID_MARBLE_CAVE_CARVER, () -> new MarbleCaveWorldCarver((Codec<CaveCarverConfiguration>)CaveCarverConfiguration.CODEC));
        ADD_CARVER_BIOME_MODIFIER_CODEC = ProjectRedExploration.BIOME_MODIFIER_SERIALIZERS.register("add_carver", ConfigFileControlledAddCarversBiomeModifier::createCodec);
        ADD_FEATURES_BIOME_MODIFIER_CODEC = ProjectRedExploration.BIOME_MODIFIER_SERIALIZERS.register("add_features", ConfigFileControlledAddFeaturesBiomeModifier::createCodec);
    }

    public static ResourceKey<ConfiguredWorldCarver<?>> createCarverKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_CARVER, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)name));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> createFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)name));
    }

    public static ResourceKey<PlacedFeature> createPlacedFeatureKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)name));
    }

    public static ResourceKey<BiomeModifier> createBiomeModifierKey(String name) {
        return ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)name));
    }

    public static void bootstrapCarvers(BootstrapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter blockGetter = context.lookup(Registries.BLOCK);
        context.register(MARBLE_CAVE_CONFIGURED_CARVER, (Object)MARBLE_CAVE_CARVER.get().configured((CarverConfiguration)new CaveCarverConfiguration(0.01f, (HeightProvider)UniformHeight.of((VerticalAnchor)VerticalAnchor.aboveBottom((int)8), (VerticalAnchor)VerticalAnchor.absolute((int)180)), (FloatProvider)UniformFloat.of((float)0.1f, (float)0.9f), VerticalAnchor.aboveBottom((int)8), CarverDebugSettings.of((boolean)false, (BlockState)Blocks.CRIMSON_BUTTON.defaultBlockState()), (HolderSet)blockGetter.getOrThrow(BlockTags.OVERWORLD_CARVER_REPLACEABLES), (FloatProvider)UniformFloat.of((float)0.7f, (float)1.4f), (FloatProvider)UniformFloat.of((float)0.8f, (float)1.3f), (FloatProvider)UniformFloat.of((float)-1.0f, (float)-0.4f))));
    }

    public static void bootstrapFeatures(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ExplorationWorldFeatures.registerOreConfiguration(context, RUBY_ORE_CONFIGURED_FEATURE, ExplorationBlocks.RUBY_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_RUBY_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, SAPPHIRE_ORE_CONFIGURED_FEATURE, ExplorationBlocks.SAPPHIRE_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_SAPPHIRE_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, PERIDOT_ORE_CONFIGURED_FEATURE, ExplorationBlocks.PERIDOT_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_PERIDOT_ORE_BLOCK, 10);
        ExplorationWorldFeatures.registerOreConfiguration(context, ELECTROTINE_ORE_CONFIGURED_FEATURE, ExplorationBlocks.ELECTROTINE_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_ELECTROTINE_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, TIN_ORE_CONFIGURED_FEATURE, ExplorationBlocks.TIN_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_TIN_ORE_BLOCK, 8);
        ExplorationWorldFeatures.registerOreConfiguration(context, SILVER_ORE_CONFIGURED_FEATURE, ExplorationBlocks.SILVER_ORE_BLOCK, ExplorationBlocks.DEEPSLATE_SILVER_ORE_BLOCK, 9);
    }

    public static void bootstrapPlacements(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        ExplorationWorldFeatures.registerOrePlacement(context, RUBY_ORE_PLACED_FEATURE, features.getOrThrow(RUBY_ORE_CONFIGURED_FEATURE), -80, 80, 1);
        ExplorationWorldFeatures.registerOrePlacement(context, SAPPHIRE_ORE_PLACED_FEATURE, features.getOrThrow(SAPPHIRE_ORE_CONFIGURED_FEATURE), -80, 80, 1);
        ExplorationWorldFeatures.registerOrePlacement(context, PERIDOT_ORE_PLACED_FEATURE, features.getOrThrow(PERIDOT_ORE_CONFIGURED_FEATURE), -80, 80, 1);
        ExplorationWorldFeatures.registerOrePlacement(context, ELECTROTINE_ORE_PLACED_FEATURE, features.getOrThrow(ELECTROTINE_ORE_CONFIGURED_FEATURE), -32, 32, 4);
        ExplorationWorldFeatures.registerOrePlacement(context, TIN_ORE_PLACED_FEATURE, features.getOrThrow(TIN_ORE_CONFIGURED_FEATURE), -24, 56, 8);
        ExplorationWorldFeatures.registerOrePlacement(context, SILVER_ORE_PLACED_FEATURE, features.getOrThrow(SILVER_ORE_CONFIGURED_FEATURE), -64, 32, 6);
    }

    public static void bootstrapBiomeModifiers(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter worldCarvers = context.lookup(Registries.CONFIGURED_CARVER);
        HolderGetter placedFeatures = context.lookup(Registries.PLACED_FEATURE);
        HolderSet.Named overworldBiomes = biomes.getOrThrow(BiomeTags.IS_OVERWORLD);
        context.register(ExplorationWorldFeatures.createBiomeModifierKey("add_ruby_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(RUBY_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, "ruby_ore"));
        context.register(ExplorationWorldFeatures.createBiomeModifierKey("add_sapphire_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(SAPPHIRE_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, "sapphire_ore"));
        context.register(ExplorationWorldFeatures.createBiomeModifierKey("add_peridot_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(PERIDOT_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, "peridot_ore"));
        context.register(ExplorationWorldFeatures.createBiomeModifierKey("add_electrotine_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(ELECTROTINE_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, "electrotine_ore"));
        context.register(ExplorationWorldFeatures.createBiomeModifierKey("add_tin_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(TIN_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, "tin_ore"));
        context.register(ExplorationWorldFeatures.createBiomeModifierKey("add_silver_ore_to_overworld"), (Object)new ConfigFileControlledAddFeaturesBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<PlacedFeature>)HolderSet.direct((Holder[])new Holder[]{placedFeatures.getOrThrow(SILVER_ORE_PLACED_FEATURE)}), GenerationStep.Decoration.UNDERGROUND_ORES, "silver_ore"));
        context.register(ExplorationWorldFeatures.createBiomeModifierKey("add_marble_cave_to_overworld"), (Object)new ConfigFileControlledAddCarversBiomeModifier((HolderSet<Biome>)overworldBiomes, (HolderSet<ConfiguredWorldCarver<?>>)HolderSet.direct((Holder[])new Holder[]{worldCarvers.getOrThrow(MARBLE_CAVE_CONFIGURED_CARVER)}), GenerationStep.Carving.AIR, ID_MARBLE_CAVE_CARVER));
    }

    private static void registerOreConfiguration(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<Block> standard, Supplier<Block> deepslate, int veinSize) {
        context.register(key, (Object)new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)new OreConfiguration((List)ImmutableList.of((Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)standard.get().defaultBlockState()), (Object)OreConfiguration.target((RuleTest)new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES), (BlockState)deepslate.get().defaultBlockState())), veinSize)));
    }

    private static void registerOrePlacement(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuredFeature, int minY, int maxY, int count) {
        ImmutableList modifiers = ImmutableList.of((Object)CountPlacement.of((int)count), (Object)InSquarePlacement.spread(), (Object)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)minY), (VerticalAnchor)VerticalAnchor.absolute((int)maxY)));
        context.register(key, (Object)new PlacedFeature(configuredFeature, (List)modifiers));
    }

    static {
        MARBLE_CAVE_CONFIGURED_CARVER = ExplorationWorldFeatures.createCarverKey(ID_MARBLE_CAVE_CARVER);
        RUBY_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("ruby_ore");
        SAPPHIRE_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("sapphire_ore");
        PERIDOT_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("peridot_ore");
        ELECTROTINE_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("electrotine_ore");
        TIN_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("tin_ore");
        SILVER_ORE_CONFIGURED_FEATURE = ExplorationWorldFeatures.createFeatureKey("silver_ore");
        RUBY_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("ruby_ore");
        SAPPHIRE_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("sapphire_ore");
        PERIDOT_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("peridot_ore");
        ELECTROTINE_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("electrotine_ore");
        TIN_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("tin_ore");
        SILVER_ORE_PLACED_FEATURE = ExplorationWorldFeatures.createPlacedFeatureKey("silver_ore");
    }
}

