/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.exploration.init;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import mrtjp.projectred.core.init.CoreTags;
import mrtjp.projectred.exploration.ProjectRedExploration;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;

public class ExplorationArmorMaterials {
    public static final String ID_RUBY_ARMOR_MATERIAL = "ruby";
    public static final String ID_SAPPHIRE_ARMOR_MATERIAL = "sapphire";
    public static final String ID_PERIDOT_ARMOR_MATERIAL = "peridot";
    public static Holder<ArmorMaterial> RUBY_ARMOR_MATERIAL;
    public static Holder<ArmorMaterial> SAPPHIRE_ARMOR_MATERIAL;
    public static Holder<ArmorMaterial> PERIDOT_ARMOR_MATERIAL;

    public static void register() {
        EnumMap defenseMap = (EnumMap)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 3);
            map.put(ArmorItem.Type.LEGGINGS, 6);
            map.put(ArmorItem.Type.CHESTPLATE, 8);
            map.put(ArmorItem.Type.HELMET, 3);
            map.put(ArmorItem.Type.BODY, 11);
        });
        RUBY_ARMOR_MATERIAL = ProjectRedExploration.ARMOR_MATERIALS.register(ID_RUBY_ARMOR_MATERIAL, () -> ExplorationArmorMaterials.create((EnumMap<ArmorItem.Type, Integer>)defenseMap, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 1.25f, 0.0f, () -> Ingredient.of((TagKey)CoreTags.RUBY_GEM_TAG), ID_RUBY_ARMOR_MATERIAL));
        SAPPHIRE_ARMOR_MATERIAL = ProjectRedExploration.ARMOR_MATERIALS.register(ID_SAPPHIRE_ARMOR_MATERIAL, () -> ExplorationArmorMaterials.create((EnumMap<ArmorItem.Type, Integer>)defenseMap, 10, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 1.25f, 0.0f, () -> Ingredient.of((TagKey)CoreTags.SAPPHIRE_GEM_TAG), ID_SAPPHIRE_ARMOR_MATERIAL));
        PERIDOT_ARMOR_MATERIAL = ProjectRedExploration.ARMOR_MATERIALS.register(ID_PERIDOT_ARMOR_MATERIAL, () -> ExplorationArmorMaterials.create((EnumMap<ArmorItem.Type, Integer>)defenseMap, 14, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 1.25f, 0.0f, () -> Ingredient.of((TagKey)CoreTags.PERIDOT_GEM_TAG), ID_PERIDOT_ARMOR_MATERIAL));
    }

    private static ArmorMaterial create(EnumMap<ArmorItem.Type, Integer> defenseMap, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient, String layerTextureName) {
        List<ArmorMaterial.Layer> list = List.of(new ArmorMaterial.Layer(ResourceLocation.fromNamespaceAndPath((String)"projectred_exploration", (String)layerTextureName)));
        return ExplorationArmorMaterials.create(defenseMap, enchantmentValue, equipSound, toughness, knockbackResistance, repairIngredient, list);
    }

    private static ArmorMaterial create(EnumMap<ArmorItem.Type, Integer> defenseMap, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient, List<ArmorMaterial.Layer> layers) {
        EnumMap<ArmorItem.Type, Integer> defenseMapCopy = new EnumMap<ArmorItem.Type, Integer>(ArmorItem.Type.class);
        for (ArmorItem.Type type : ArmorItem.Type.values()) {
            defenseMapCopy.put(type, defenseMap.get(type));
        }
        return new ArmorMaterial(defenseMapCopy, enchantmentValue, equipSound, repairIngredient, layers, toughness, knockbackResistance);
    }
}

