/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox.text;

import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Formatting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.NotNull;

public class FormattedString
extends ArrayList<Char>
implements CharSequence,
FormattedText {
    public FormattedString() {
    }

    public FormattedString(@NotNull Collection<? extends Char> chars) {
        super(chars);
    }

    public static FormattedString parse(String string) {
        return new FormattedString((Collection<? extends Char>)FormattedString.parseChars(string));
    }

    public static FormattedString parseWithoutFormatting(String string) {
        return new FormattedString((Collection<? extends Char>)string.chars().mapToObj(Char::new).toList());
    }

    public static ArrayList<Char> parseChars(String string) {
        ArrayList<Char> chars = new ArrayList<Char>();
        Formatting formatting = Formatting.EMPTY;
        boolean grabbingFormattingChar = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u00a7') {
                grabbingFormattingChar = true;
                continue;
            }
            if (grabbingFormattingChar) {
                formatting = formatting.with(c);
                grabbingFormattingChar = false;
                continue;
            }
            chars.add(new Char(c, formatting));
        }
        return chars;
    }

    public FormattedString subString(int start, int end) {
        return new FormattedString(this.subList(start, end));
    }

    @Override
    public int length() {
        return this.size();
    }

    @Override
    public char charAt(int index) {
        return ((Char)this.get(index)).character();
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        return this.subString(start, end);
    }

    @NotNull
    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> acceptor) {
        return acceptor.accept(this.toStringWithoutFormatting());
    }

    @NotNull
    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> acceptor, Style style) {
        return acceptor.accept(style, this.toString());
    }

    @Override
    @NotNull
    public String toString() {
        return this.toString(false);
    }

    @NotNull
    public String toString(boolean skipNewLines) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Char previousChar = Char.EMPTY;
        for (Char character : this) {
            if (skipNewLines && character.character() == '\n') continue;
            if (!character.formatting().equals(previousChar.formatting())) {
                if (previousChar.hasFormatting()) {
                    Formatting.RESET.append(sb);
                }
                character.formatting().append(sb);
            }
            sb.append(character.character());
            previousChar = character;
        }
        Char lastChar = (Char)this.get(this.size() - 1);
        if (lastChar.hasFormatting()) {
            Formatting.RESET.append(sb);
        }
        return sb.toString();
    }

    @NotNull
    public String toStringWithoutFormatting() {
        return this.toStringWithoutFormatting(false);
    }

    @NotNull
    public String toStringWithoutFormatting(boolean skipNewLines) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Char character : this) {
            if (skipNewLines && character.character() == '\n') continue;
            sb.append(character.character());
        }
        return sb.toString();
    }
}

