/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.widget.textbox.display;

import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.Line;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedStringEditor;
import io.github.mortuusars.scholar.client.util.Pos2i;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.Rect2i;

public class FormattedStringDisplayCache {
    protected FormattedStringEditor editor;
    protected Font font;
    protected int width = 0;
    protected int height = 0;
    protected HorizontalAlignment alignment;
    protected Pos2i cursor = new Pos2i(0, 0);
    protected ArrayList<Line> lines = new ArrayList();
    protected ArrayList<Rect2i> selection = new ArrayList();
    boolean shouldUpdate = true;

    public FormattedStringDisplayCache(FormattedStringEditor editor) {
        this.editor = editor;
    }

    public boolean shouldUpdate() {
        return this.shouldUpdate;
    }

    public void scheduleUpdate() {
        this.shouldUpdate = true;
    }

    public void update(Font font, int width, int height, HorizontalAlignment alignment) {
        this.font = font;
        this.width = width;
        this.height = height;
        this.alignment = alignment;
        this.updateLines();
        this.updateCursor();
        this.updateSelectionAreas();
        this.shouldUpdate = false;
    }

    protected void updateLines() {
        this.lines.clear();
        this.lines.addAll(this.splitLines(this.editor.getString(), this.font, this.width, this.alignment));
    }

    protected void updateCursor() {
        Line cursorLine = this.lines.get(this.findLineIndexByCharIndex(this.editor.getCursorPos()));
        int lineCursorIndex = this.editor.getCursorPos() - cursorLine.firstCharIndex();
        int x = cursorLine.x + cursorLine.widthToIndex(this.font, lineCursorIndex);
        int y = cursorLine.y;
        this.cursor = new Pos2i(x, y);
        if (this.editor.isCursorAtEnd() && cursorLine.isEmpty()) {
            int n = this.cursor.x;
            this.cursor.x = n - (switch (this.alignment) {
                default -> throw new MatchException(null, null);
                case HorizontalAlignment.LEFT -> 0;
                case HorizontalAlignment.CENTER -> this.font.width("_") / 2;
                case HorizontalAlignment.RIGHT -> this.font.width("_");
            });
        }
    }

    protected void updateSelectionAreas() {
        this.selection.clear();
        if (!this.editor.isSelecting()) {
            return;
        }
        int selectionStartIndex = this.editor.getSelectionStart();
        int selectionEndIndex = this.editor.getSelectionEnd();
        int lineAtStart = this.findLineIndexByCharIndex(selectionStartIndex);
        int lineAtEnd = this.findLineIndexByCharIndex(selectionEndIndex);
        for (int lineIndex = lineAtStart; lineIndex <= lineAtEnd; ++lineIndex) {
            Line line = this.lines.get(lineIndex);
            if (line.isEmpty() && lineIndex == lineAtEnd) continue;
            int firstCharIndex = line.firstCharIndex();
            int firstLineChar = Math.max(selectionStartIndex - firstCharIndex, 0);
            int lastLineChar = Math.min(selectionEndIndex - 1 - firstCharIndex, line.getString().size() - 1);
            int width = line.width(this.font, firstLineChar, lastLineChar);
            Objects.requireNonNull(this.font);
            int height = 9;
            int x = line.x + line.widthToIndex(this.font, firstLineChar);
            int y = line.y;
            if (line.renderedString().isEmpty()) {
                x -= (switch (this.alignment) {
                    default -> throw new MatchException(null, null);
                    case HorizontalAlignment.LEFT -> 0;
                    case HorizontalAlignment.CENTER -> width / 2;
                    case HorizontalAlignment.RIGHT -> width;
                });
            }
            this.selection.add(new Rect2i(x, y, width, height));
        }
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public Line getLine(int line) {
        return this.lines.get(line);
    }

    public ArrayList<Rect2i> getSelection() {
        return this.selection;
    }

    public Pos2i getCursor() {
        return this.cursor;
    }

    public int findLineIndexByCharIndex(int index) {
        for (int i = 0; i < this.lines.size(); ++i) {
            Line line = this.lines.get(i);
            if (line.firstCharIndex() > index || index > line.lastCharIndex()) continue;
            return i;
        }
        return Math.max(0, this.lines.size() - 1);
    }

    public int getCharIndexAtPosition(Font font, int x, int y) {
        Objects.requireNonNull(font);
        int lineIndex = y / 9;
        if (lineIndex < 0) {
            return 0;
        }
        if (lineIndex >= this.lines.size()) {
            return this.editor.length();
        }
        Line line = this.getLine(lineIndex);
        return line.indexAtWidth(font, x - line.x);
    }

    public List<Line> splitLines(FormattedString string, Font font, int width, HorizontalAlignment alignment) {
        ArrayList<Line> lines = new ArrayList<Line>();
        if (string.isEmpty()) {
            int x = alignment.align(width, 0);
            int y = 0;
            lines.add(new Line(font, new FormattedString(), 0, 0, "", 0, x, y));
            return lines;
        }
        int i = 0;
        while (i < string.size()) {
            int firstCharIndex = i;
            int lineWidth = 0;
            int lastSpaceIndex = -1;
            while (i < string.size()) {
                Char character = (Char)string.get(i);
                int charWidth = character.getWidth(font, true);
                if (character.character() == ' ') {
                    lastSpaceIndex = i;
                }
                if (lineWidth + charWidth > width) {
                    if (lastSpaceIndex == -1) break;
                    i = lastSpaceIndex + 1;
                    break;
                }
                lineWidth += charWidth;
                ++i;
                if (character.character() != '\n') continue;
                break;
            }
            FormattedString lineString = string.subString(firstCharIndex, i);
            String renderedString = lineString.toString(true);
            int x = alignment.align(width, lineWidth);
            int n = lines.size();
            Objects.requireNonNull(font);
            int y = n * 9;
            lines.add(new Line(font, lineString, firstCharIndex, i - 1, renderedString, lineWidth, x, y));
        }
        Line lastLine = (Line)lines.get(lines.size() - 1);
        if (lastLine.endsWithNewLine()) {
            int x = alignment.align(width, 0);
            int n = lines.size();
            Objects.requireNonNull(font);
            int y = n * 9;
            lines.add(new Line(font, new FormattedString(), lastLine.lastCharIndex() + 1, lastLine.lastCharIndex() + 1, "", 0, x, y));
        }
        return lines;
    }
}

