/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen.edit;

import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.ScholarClient;
import io.github.mortuusars.scholar.book.BookColor;
import io.github.mortuusars.scholar.book.Spread;
import io.github.mortuusars.scholar.client.gui.Widgets;
import io.github.mortuusars.scholar.client.gui.screen.BookSigningScreen;
import io.github.mortuusars.scholar.client.gui.screen.SpreadBookScreen;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedStringEditor;
import io.github.mortuusars.scholar.client.util.FileDialogs;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import io.github.mortuusars.scholar.util.Change;
import io.github.mortuusars.scholar.util.History;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WritableBookContent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpreadBookEditScreen
extends SpreadBookScreen {
    public static final WidgetSprites ENTER_SIGN_MODE_SPRITES = Widgets.threeStateSprites(Scholar.resource("book/sign_button"));
    public static final WidgetSprites INSERT_EMPTY_PAGE_SPRITES = Widgets.threeStateSprites(Scholar.resource("book/insert_empty_page_button"));
    public static final WidgetSprites REMOVE_PAGE_SPRITES = Widgets.threeStateSprites(Scholar.resource("book/remove_page_button"));
    public static final WidgetSprites IMPORT_BOOK_SPRITES = Widgets.threeStateSprites(Scholar.resource("book/import_book_button"));
    public static final WidgetSprites EXPORT_BOOK_SPRITES = Widgets.threeStateSprites(Scholar.resource("book/export_book_button"));
    protected final ItemStack bookStack;
    protected final InteractionHand hand;
    protected final List<String> pages = new ArrayList<String>();
    protected final History history = new History();
    protected TextBox rightPageTextBox;
    protected TextBox leftPageTextBox;
    protected ImageButton insertEmptyPageLeftButton;
    protected ImageButton removePageLeftButton;
    protected ImageButton insertEmptyPageRightButton;
    protected ImageButton removePageRightButton;
    protected ImageButton exportBookButton;
    protected ImageButton importBookButton;
    protected boolean bookModified;

    public SpreadBookEditScreen(ItemStack bookStack, InteractionHand hand) {
        super(BookColor.of(bookStack));
        this.bookStack = bookStack;
        this.hand = hand;
    }

    public History getHistory() {
        return this.history;
    }

    protected void setupPages(ItemStack bookStack) {
        this.pages.clear();
        @Nullable WritableBookContent content = (WritableBookContent)bookStack.get(DataComponents.WRITABLE_BOOK_CONTENT);
        if (content != null) {
            content.getPages(Minecraft.getInstance().isTextFilteringEnabled()).forEach(this.pages::add);
        }
        while (this.pages.size() < 2) {
            this.pages.add("");
        }
        this.setTextBoxes(false);
    }

    @Override
    protected void createWidgets() {
        this.leftPageTextBox = new TextBox(this.font, this.leftPos + 22, this.topPos + 21, 114, 128).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setText(FormattedString.parse(this.getPageText(Spread.Side.LEFT))).setOnTextChanged(text -> this.setPageText(Spread.Side.LEFT, text.toString()));
        this.addRenderableWidget((GuiEventListener)this.leftPageTextBox);
        this.rightPageTextBox = new TextBox(this.font, this.leftPos + 159, this.topPos + 21, 114, 128).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setText(FormattedString.parse(this.getPageText(Spread.Side.RIGHT))).setOnTextChanged(text -> this.setPageText(Spread.Side.RIGHT, text.toString()));
        this.addRenderableWidget((GuiEventListener)this.rightPageTextBox);
        this.setupPages(this.bookStack);
        this.createPageToolButtons();
        this.createPrevPageButton();
        this.createNextPageButton();
        this.createImportExportButtons();
        ImageButton enterSignModeButton = new ImageButton(this.leftPos - 24, this.topPos + 18, 22, 22, ENTER_SIGN_MODE_SPRITES, b -> this.enterSignMode(), (Component)Component.translatable((String)"book.signButton"));
        enterSignModeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"book.signButton")));
        this.addRenderableWidget((GuiEventListener)enterSignModeButton);
        this.createBottomButtons();
    }

    protected void createPageToolButtons() {
        this.insertEmptyPageLeftButton = new ImageButton(this.leftPos + 112, this.topPos + 154, 13, 13, INSERT_EMPTY_PAGE_SPRITES, b -> this.insertEmptyPage(Spread.Side.LEFT), (Component)Component.translatable((String)"gui.scholar.insert_empty_page"));
        this.insertEmptyPageLeftButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.scholar.insert_empty_page").append(" ").append((Component)Component.translatable((String)"gui.scholar.insert_empty_page_left.hotkey"))));
        this.addRenderableWidget((GuiEventListener)this.insertEmptyPageLeftButton);
        this.removePageLeftButton = new ImageButton(this.leftPos + 126, this.topPos + 154, 13, 13, REMOVE_PAGE_SPRITES, b -> this.removePage(Spread.Side.LEFT), (Component)Component.translatable((String)"gui.scholar.remove_page"));
        this.removePageLeftButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.scholar.remove_page").append(" ").append((Component)Component.translatable((String)"gui.scholar.remove_page_left.hotkey"))));
        this.addRenderableWidget((GuiEventListener)this.removePageLeftButton);
        this.insertEmptyPageRightButton = new ImageButton(this.leftPos + 156, this.topPos + 154, 13, 13, INSERT_EMPTY_PAGE_SPRITES, b -> this.insertEmptyPage(Spread.Side.RIGHT), (Component)Component.translatable((String)"gui.scholar.insert_empty_page"));
        this.insertEmptyPageRightButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.scholar.insert_empty_page").append(" ").append((Component)Component.translatable((String)"gui.scholar.insert_empty_page_right.hotkey"))));
        this.addRenderableWidget((GuiEventListener)this.insertEmptyPageRightButton);
        this.removePageRightButton = new ImageButton(this.leftPos + 170, this.topPos + 154, 13, 13, REMOVE_PAGE_SPRITES, b -> this.removePage(Spread.Side.RIGHT), (Component)Component.translatable((String)"gui.scholar.remove_page"));
        this.removePageRightButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.scholar.remove_page").append(" ").append((Component)Component.translatable((String)"gui.scholar.remove_page_right.hotkey"))));
        this.addRenderableWidget((GuiEventListener)this.removePageRightButton);
    }

    protected void createImportExportButtons() {
        this.importBookButton = new ImageButton(this.leftPos + 297, this.topPos + 16, 18, 18, IMPORT_BOOK_SPRITES, b -> this.importBook(Screen.hasShiftDown()), (Component)Component.translatable((String)"gui.scholar.import_book"));
        this.importBookButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.scholar.import_book").append((Component)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.importBook)).append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"gui.scholar.import_book.tooltip"))));
        this.addRenderableWidget((GuiEventListener)this.importBookButton);
        this.exportBookButton = new ImageButton(this.leftPos + 297, this.topPos + 41, 18, 18, EXPORT_BOOK_SPRITES, b -> this.exportBook(Screen.hasShiftDown()), (Component)Component.translatable((String)"gui.scholar.export_book"));
        this.exportBookButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.scholar.export_book").append((Component)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.exportBook)).append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"gui.scholar.export_book.tooltip"))));
        this.addRenderableWidget((GuiEventListener)this.exportBookButton);
    }

    @Override
    protected void toggleBookTools() {
        super.toggleBookTools();
        this.playButtonClickSound();
    }

    @Override
    protected void updateButtonVisibility() {
        super.updateButtonVisibility();
        this.insertEmptyPageLeftButton.visible = this.isToolsVisible();
        this.insertEmptyPageLeftButton.active = this.canInsertEmptyPage(Spread.Side.LEFT);
        this.insertEmptyPageRightButton.visible = this.isToolsVisible();
        this.insertEmptyPageRightButton.active = this.canInsertEmptyPage(Spread.Side.RIGHT);
        this.removePageLeftButton.visible = this.isToolsVisible();
        this.removePageLeftButton.active = this.canRemovePage(Spread.Side.LEFT);
        this.removePageRightButton.visible = this.isToolsVisible();
        this.removePageRightButton.active = this.canRemovePage(Spread.Side.RIGHT);
        this.exportBookButton.visible = this.isToolsVisible();
        this.exportBookButton.active = this.pages.stream().anyMatch(p -> !p.isEmpty());
        this.importBookButton.visible = this.isToolsVisible();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtonVisibility();
        this.renderTransparentBackground(guiGraphics);
        this.renderBook(guiGraphics, mouseX, mouseY, partialTick);
        this.renderPageNumbers(guiGraphics, mouseX, mouseY, partialTick, this.currentSpread);
        this.renderTools(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    protected void renderBook(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        RenderUtil.withColorMultiplied(this.bookColor, () -> {
            if (this.isToolsVisible()) {
                guiGraphics.blit(TEXTURE, this.leftPos + 295, this.topPos + 14, 0.0f, 388.0f, 23, 48, 512, 512);
            }
            guiGraphics.blit(TEXTURE, (this.width - 295) / 2, (this.height - 180) / 2, 295, 180, 0.0f, 0.0f, 295, 180, 512, 512);
            guiGraphics.blit(TEXTURE, this.leftPos - 29, this.topPos + 14, 0.0f, 360.0f, 29, 28, 512, 512);
        });
        guiGraphics.blit(TEXTURE, (this.width - 295) / 2, (this.height - 180) / 2, 295, 180, 0.0f, 180.0f, 295, 180, 512, 512);
    }

    @Override
    protected void renderTools(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.width - 12;
        int y = 6;
        guiGraphics.drawString(this.font, "?", x, y, -5592406);
        if (mouseX >= x - 3 && mouseX < x + 12 + 3 && mouseY >= y - 3 && mouseY < y + 12) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.translatable((String)"gui.scholar.tools.toggle").append((Component)ScholarClient.KeyMappings.componentForTooltip(ScholarClient.KeyMappings.toggleBookTools)));
            tooltip.add(Component.translatable((String)"gui.scholar.tools.tooltip.copy_with_formatting"));
            tooltip.add(Component.translatable((String)"gui.scholar.tools.tooltip.paste_with_formatting"));
            tooltip.add(Component.translatable((String)"gui.scholar.tools.tooltip.undo"));
            tooltip.add(Component.translatable((String)"gui.scholar.tools.tooltip.redo"));
            guiGraphics.renderTooltip(this.font, tooltip, Optional.empty(), mouseX, mouseY + 20);
        }
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int modifiers) {
        TextBox textBox;
        if (ScholarClient.KeyMappings.importBook.matches(key, scanCode)) {
            this.playButtonClickSound();
            this.importBook(Screen.hasShiftDown());
            return true;
        }
        if (ScholarClient.KeyMappings.exportBook.matches(key, scanCode)) {
            this.playButtonClickSound();
            this.exportBook(Screen.hasShiftDown());
            return true;
        }
        if (Screen.hasControlDown() && key == 90 && !Screen.hasAltDown()) {
            Change change;
            float pitch = Screen.hasShiftDown() ? ((change = this.getHistory().redo()) == null ? 1.4f : 0.8f) : ((change = this.getHistory().undo()) == null ? 1.8f : 0.95f);
            this.playButtonClickSound(pitch);
            return true;
        }
        GuiEventListener pitch = this.getFocused();
        if (!(pitch instanceof TextBox && (textBox = (TextBox)pitch).getEditor().isSelecting() || key != 67 || !Screen.hasControlDown() || Screen.hasAltDown())) {
            String bookContents = this.getBookContents(Screen.hasShiftDown());
            Minecraft.getInstance().keyboardHandler.setClipboard(bookContents);
            return true;
        }
        if (Screen.hasControlDown() && Screen.hasShiftDown() && key == 260) {
            this.insertEmptyPage(Screen.hasAltDown() ? Spread.Side.RIGHT : Spread.Side.LEFT);
            return true;
        }
        if (Screen.hasControlDown() && Screen.hasShiftDown() && key == 261) {
            this.removePage(Screen.hasAltDown() ? Spread.Side.RIGHT : Spread.Side.LEFT);
            return true;
        }
        return super.keyPressed(key, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int x = this.width - 12;
        int y = 6;
        if (mouseX >= (double)(x - 3) && mouseX < (double)(x + 12 + 3) && mouseY >= (double)(y - 3) && mouseY < (double)(y + 12)) {
            this.toggleBookTools();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected boolean pageForward() {
        if (super.pageForward()) {
            while (this.pages.size() < (this.currentSpread + 1) * 2) {
                this.appendEmptyPage();
            }
            this.setTextBoxes();
            this.getHistory().add(() -> {
                super.pageForward();
                this.setTextBoxes();
            }, () -> {
                super.pageBack();
                this.setTextBoxes();
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean pageBack() {
        if (super.pageBack()) {
            this.setTextBoxes();
            this.getHistory().add(() -> {
                super.pageBack();
                this.setTextBoxes();
            }, () -> {
                super.pageForward();
                this.setTextBoxes();
            });
            return true;
        }
        return false;
    }

    protected void setTextBoxes() {
        this.setTextBoxes(true);
    }

    protected void setTextBoxes(boolean resetCursor) {
        FormattedString leftString = FormattedString.parse(this.getPageText(Spread.Side.LEFT));
        if (!leftString.equals(this.leftPageTextBox.getEditor().getString())) {
            this.leftPageTextBox.getEditor().setString(leftString);
            int leftCursorPos = resetCursor ? 0 : this.leftPageTextBox.getEditor().getCursorPos();
            this.leftPageTextBox.getEditor().setCursorPos(leftCursorPos, false);
        }
        this.leftPageTextBox.getDisplayCache().scheduleUpdate();
        FormattedString rightString = FormattedString.parse(this.getPageText(Spread.Side.RIGHT));
        if (!rightString.equals(this.rightPageTextBox.getEditor().getString())) {
            this.rightPageTextBox.getEditor().setString(rightString);
            int rightCursorPos = resetCursor ? 0 : this.rightPageTextBox.getEditor().getCursorPos();
            this.rightPageTextBox.getEditor().setCursorPos(rightCursorPos, false);
        }
        this.rightPageTextBox.getDisplayCache().scheduleUpdate();
    }

    protected void enterSignMode() {
        this.saveChanges(false, null);
        this.minecraft.execute(() -> this.minecraft.setScreen((Screen)new BookSigningScreen(this, this.bookColor, title -> this.saveChanges(true, (String)title))));
    }

    protected String getPageText(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        return pageIndex >= 0 && pageIndex < this.pages.size() ? this.pages.get(pageIndex) : "";
    }

    protected void setPageText(Spread.Side side, String text) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        while (pageIndex > this.pages.size() - 1 && pageIndex < this.getPageCount()) {
            this.appendEmptyPage();
        }
        if (pageIndex >= 0 && pageIndex < this.pages.size()) {
            String currentText = this.getPageText(side);
            this.getHistory().add(() -> {
                this.pages.set(pageIndex, text);
                this.bookModified = true;
                this.setTextBoxes(false);
            }, () -> {
                this.pages.set(pageIndex, currentText);
                this.bookModified = true;
                this.setTextBoxes(false);
            });
            this.pages.set(pageIndex, text);
            this.bookModified = true;
        }
    }

    protected void appendEmptyPage() {
        if (this.pages.size() < 100) {
            this.pages.add("");
        }
    }

    protected void insertEmptyPage(Spread.Side side) {
        if (!this.canInsertEmptyPage(side)) {
            Objects.requireNonNull(Minecraft.getInstance().player).displayClientMessage((Component)Component.translatable((String)"gui.scholar.cannot_insert_page"), false);
            return;
        }
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        Change change = Change.create(() -> {
            this.pages.add(pageIndex, "");
            while (this.pages.size() >= 100) {
                this.pages.removeLast();
            }
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(1.0f, 0.6f);
        }, () -> {
            this.pages.remove(pageIndex);
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(1.0f, 0.8f);
        });
        change.apply();
        this.getHistory().add(change);
    }

    protected void removePage(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        String pageContent = this.pages.get(pageIndex);
        Change change = Change.create(() -> {
            this.pages.remove(pageIndex);
            while (this.pages.size() < Spread.Side.RIGHT.getPageIndexFromSpread(this.currentSpread) + 1) {
                this.pages.add("");
            }
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(0.85f, 0.6f);
        }, () -> {
            this.pages.add(pageIndex, pageContent);
            this.setTextBoxes();
            this.bookModified = true;
            this.playPageTurnSound(0.85f, 0.8f);
        });
        change.apply();
        this.getHistory().add(change);
    }

    protected void saveChanges(boolean sign, @Nullable String title) {
        if (this.bookModified || sign) {
            if (!sign) {
                title = null;
            }
            if (title != null && title.length() > 32) {
                title = title.substring(32);
            }
            this.removeEmptyTrailingPages();
            this.updateLocalCopy();
            this.sendChanges(title);
        }
    }

    protected void sendChanges(@Nullable String title) {
        int slotId = this.hand == InteractionHand.MAIN_HAND ? this.player.getInventory().selected : 40;
        Objects.requireNonNull(this.minecraft.getConnection()).send((Packet)new ServerboundEditBookPacket(slotId, this.pages, Optional.ofNullable(title)));
    }

    protected void removeEmptyTrailingPages() {
        ListIterator<String> iterator = this.pages.listIterator(this.pages.size());
        while (iterator.hasPrevious() && iterator.previous().isEmpty()) {
            iterator.remove();
        }
    }

    protected void updateLocalCopy() {
        this.bookStack.set(DataComponents.WRITABLE_BOOK_CONTENT, (Object)new WritableBookContent(this.pages.stream().map(Filterable::passThrough).toList()));
    }

    protected boolean canInsertEmptyPage(Spread.Side side) {
        int pageIndex = side.getPageIndexFromSpread(this.currentSpread);
        int lastPageWithContent = this.getLastPageWithContent().orElse(-1);
        return lastPageWithContent < 99 && pageIndex <= lastPageWithContent;
    }

    protected boolean canRemovePage(Spread.Side side) {
        return this.containsContentAfter(side.getPageIndexFromSpread(this.currentSpread));
    }

    protected OptionalInt getLastPageWithContent() {
        for (int i = this.pages.size() - 1; i >= 0; --i) {
            if (this.pages.get(i).isEmpty()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    protected boolean containsContentAfter(int pageIndex) {
        return this.pages.stream().skip(pageIndex).anyMatch(p -> !p.isEmpty());
    }

    public String getBookContents(boolean withFormatting) {
        String contents = String.join((CharSequence)"\n", this.pages);
        if (!withFormatting) {
            ChatFormatting.stripFormatting((String)contents);
        }
        return contents;
    }

    public void setBookContents(String contents, boolean withFormatting) {
        ArrayList<String> oldPages = new ArrayList<String>(this.pages);
        this.pages.clear();
        contents = contents.replaceAll("\\r", "");
        if (!withFormatting) {
            contents = ChatFormatting.stripFormatting((String)contents);
        }
        String[] pages = contents.split("\f");
        Predicate<String> validator = FormattedStringEditor.Validator.fitInDimensions(this.font, this.leftPageTextBox.getWidth(), this.leftPageTextBox.getHeight());
        for (String pageContent : pages) {
            if (pageContent.isEmpty()) {
                this.pages.add("");
                continue;
            }
            FormattedString string = FormattedString.parse(pageContent);
            int currentChar = 0;
            FormattedString currentString = new FormattedString();
            String lastValidString = "";
            while (currentChar < string.length()) {
                currentString.add((Char)string.get(currentChar));
                ++currentChar;
                String str = currentString.toString();
                if (!validator.test(str)) {
                    this.pages.add(lastValidString);
                    if (this.pages.size() >= 100) {
                        lastValidString = "";
                        break;
                    }
                    --currentChar;
                    currentString.clear();
                    continue;
                }
                lastValidString = str;
            }
            if (lastValidString.isEmpty() || this.pages.size() > 100) continue;
            this.pages.add(lastValidString);
        }
        this.bookModified = true;
        this.setTextBoxes();
        ArrayList<String> newPages = new ArrayList<String>(this.pages);
        this.getHistory().add(() -> {
            this.pages.clear();
            this.pages.addAll(newPages);
            this.bookModified = true;
            this.setTextBoxes();
        }, () -> {
            this.pages.clear();
            this.pages.addAll(oldPages);
            this.bookModified = true;
            this.setTextBoxes();
        });
    }

    public void importBook(boolean withFormatting) {
        CompletableFuture.runAsync(() -> {
            Object defaultDirectory = Minecraft.getInstance().gameDirectory.toPath().toAbsolutePath().normalize().toString();
            if (!((String)defaultDirectory).endsWith(File.separator)) {
                defaultDirectory = (String)defaultDirectory + File.separator;
            }
            String title = Component.translatable((String)"gui.scholar.import_book").getString();
            FileDialogs.loadFile((String)defaultDirectory, title, "Text Files (.txt)", false, "*.txt").ifPresent(filePath -> {
                try {
                    String content = Files.readString(Path.of(filePath, new String[0]));
                    Minecraft.getInstance().execute(() -> this.setBookContents(content, withFormatting));
                }
                catch (IOException e) {
                    Minecraft.getInstance().execute(() -> this.player.displayClientMessage((Component)Component.translatable((String)"gui.scholar.import_book.failure"), false));
                    Scholar.LOGGER.error("Failed to import book: ", (Throwable)e);
                }
            });
        }).exceptionally(e -> {
            Minecraft.getInstance().execute(() -> this.player.displayClientMessage((Component)Component.translatable((String)"gui.scholar.import_book.failure"), false));
            Scholar.LOGGER.error("Failed to import book: ", e);
            return null;
        });
    }

    public void exportBook(boolean withFormatting) {
        String content = withFormatting ? String.join((CharSequence)"\f", this.pages) : ChatFormatting.stripFormatting((String)String.join((CharSequence)"\f", this.pages));
        CompletableFuture.runAsync(() -> {
            Object defaultDirectory = Minecraft.getInstance().gameDirectory.toPath().toAbsolutePath().normalize().toString();
            if (!((String)defaultDirectory).endsWith(File.separator)) {
                defaultDirectory = (String)defaultDirectory + File.separator;
            }
            String title = Component.translatable((String)"gui.scholar.export_book").getString();
            FileDialogs.saveFile((String)defaultDirectory, title, "Text Files (.txt)", "*.txt").ifPresent(filePath -> {
                try {
                    Files.writeString(Path.of(filePath, new String[0]), (CharSequence)content, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                    MutableComponent filePathComponent = Component.literal((String)filePath).withStyle(Style.EMPTY.withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, filePath)));
                    Minecraft.getInstance().execute(() -> this.player.displayClientMessage((Component)Component.translatable((String)"gui.scholar.export_book.success").append((Component)filePathComponent), false));
                }
                catch (IOException e) {
                    Minecraft.getInstance().execute(() -> this.player.displayClientMessage((Component)Component.translatable((String)"gui.scholar.export_book.failure"), false));
                    Scholar.LOGGER.error("Failed to export book: ", (Throwable)e);
                }
            });
        }).exceptionally(e -> {
            Minecraft.getInstance().execute(() -> this.player.displayClientMessage((Component)Component.translatable((String)"gui.scholar.export_book.failure"), false));
            Scholar.LOGGER.error("Failed to export book: ", e);
            return null;
        });
    }

    public void onClose() {
        this.saveChanges(false, null);
        super.onClose();
    }
}

