/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.scholar.client.gui.screen;

import io.github.mortuusars.scholar.Config;
import io.github.mortuusars.scholar.Scholar;
import io.github.mortuusars.scholar.client.gui.Widgets;
import io.github.mortuusars.scholar.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.scholar.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.scholar.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.scholar.client.util.RenderUtil;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class BookSigningScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Scholar.resource("textures/gui/book_signing.png");
    public static final WidgetSprites SIGN_BUTTON_SPRITES = Widgets.threeStateSprites(Scholar.resource("signing/sign_button"));
    public static final WidgetSprites CANCEL_BUTTON_SPRITES = Widgets.threeStateSprites(Scholar.resource("signing/cancel_button"));
    @NotNull
    protected final Minecraft minecraft;
    @NotNull
    protected final Player player;
    protected final Screen parentScreen;
    protected final int bookColor;
    protected final Consumer<String> onSign;
    protected int textColor;
    protected int selectionColor;
    protected int selectionUnfocusedColor;
    protected int enterBookTitleFontColor;
    protected int byAuthorFontColor;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int textureWidth;
    protected int textureHeight;
    protected TextBox titleTextBox;
    protected ImageButton signButton;
    protected ImageButton cancelSigningButton;
    protected String titleText = "";

    public BookSigningScreen(Screen parentScreen, int bookColor, Consumer<String> onSign) {
        super((Component)Component.empty());
        this.parentScreen = parentScreen;
        this.bookColor = bookColor;
        this.onSign = onSign;
        this.textColor = Config.Client.getColor(Config.Client.TEXT_COLOR);
        this.selectionColor = Config.Client.getColor(Config.Client.SELECTION_COLOR);
        this.selectionUnfocusedColor = Config.Client.getColor(Config.Client.SELECTION_UNFOCUSED_COLOR);
        this.enterBookTitleFontColor = Config.Client.getColor(Config.Client.ENTER_TITLE_COLOR);
        this.byAuthorFontColor = Config.Client.getColor(Config.Client.BY_AUTHOR_COLOR);
        this.minecraft = Minecraft.getInstance();
        this.player = (Player)Objects.requireNonNull(this.minecraft.player);
        this.textureWidth = 256;
        this.textureHeight = 256;
    }

    public boolean isPauseScreen() {
        return (Boolean)Config.Client.SCREEN_PAUSE.get();
    }

    protected void init() {
        this.imageWidth = 149;
        this.imageHeight = 180;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.titleTextBox = new TextBox(this.font, this.leftPos + 21, this.topPos + 71, 108, 9).setFontColor(this.textColor).setFontUnfocusedColor(this.textColor).setSelectionColor(this.selectionColor).setSelectionUnfocusedColor(this.selectionUnfocusedColor).setHorizontalAlignment(HorizontalAlignment.CENTER).setOnTextChanged(this::setTitleText).setTextValidator(text -> text != null && text.length() <= 32 && this.font.wordWrapHeight(text, 108) <= 9 && !text.contains("\n"));
        this.addRenderableWidget((GuiEventListener)this.titleTextBox);
        this.signButton = new ImageButton(this.leftPos + 46, this.topPos + 108, 22, 22, SIGN_BUTTON_SPRITES, b -> this.signAlbum(), (Component)Component.translatable((String)"book.finalizeButton"));
        this.addRenderableWidget((GuiEventListener)this.signButton);
        this.cancelSigningButton = new ImageButton(this.leftPos + 83, this.topPos + 108, 22, 22, CANCEL_BUTTON_SPRITES, b -> this.cancelSigning(), CommonComponents.GUI_CANCEL);
        this.cancelSigningButton.setTooltip(Tooltip.create((Component)CommonComponents.GUI_CANCEL));
        this.addRenderableWidget((GuiEventListener)this.cancelSigningButton);
        this.setInitialFocus((GuiEventListener)this.titleTextBox);
        this.updateButtons();
    }

    protected void setTitleText(FormattedString text) {
        this.titleText = text.toString();
        this.updateButtons();
    }

    protected void updateButtons() {
        boolean canSign;
        this.signButton.active = canSign = this.canSign();
        MutableComponent component = Component.translatable((String)"book.finalizeButton").append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"book.finalizeWarning").withStyle(ChatFormatting.GRAY));
        if (!canSign && this.titleText.length() > 32) {
            component.append(CommonComponents.NEW_LINE);
            component.append((Component)Component.translatable((String)"scholar.book_singing.error_title_too_long").withStyle(ChatFormatting.RED));
        }
        this.signButton.setTooltip(Tooltip.create((Component)component));
    }

    protected boolean canSign() {
        String text = this.titleText.trim();
        return !text.isBlank() && text.length() <= 32;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        this.renderTransparentBackground(guiGraphics);
        RenderUtil.withColorMultiplied(this.bookColor, () -> guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.textureWidth, this.textureHeight));
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos + 31, 0, 0.0f, 180.0f, this.imageWidth, 76, this.textureWidth, this.textureHeight);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderLabels(GuiGraphics guiGraphics) {
        MutableComponent component = Component.translatable((String)"book.editTitle");
        guiGraphics.drawString(this.font, (Component)component, this.leftPos + 74 - this.font.width((FormattedText)component) / 2, this.topPos + 51, this.enterBookTitleFontColor, false);
        component = Component.translatable((String)"book.byAuthor", (Object[])new Object[]{this.player.getName()});
        guiGraphics.drawString(this.font, (Component)component, this.leftPos + 74 - this.font.width((FormattedText)component) / 2, this.topPos + 81, this.byAuthorFontColor, false);
    }

    protected void signAlbum() {
        if (this.canSign()) {
            this.onSign.accept(this.titleText.trim());
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Scholar.SoundEvents.BOOK_SIGNED.get(), (float)1.0f, (float)0.8f));
            this.onClose();
        }
    }

    protected void cancelSigning() {
        this.minecraft.setScreen(this.parentScreen);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.cancelSigning();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

