/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.client.gui.widget.IntegerSliderWidget;
import net.conczin.immersive_paintings.client.gui.widget.PaintingWidget;
import net.conczin.immersive_paintings.client.gui.widget.PercentageSliderWidget;
import net.conczin.immersive_paintings.client.gui.widget.TexturedButtonWidget;
import net.conczin.immersive_paintings.entity.ImmersivePaintingEntity;
import net.conczin.immersive_paintings.network.LazyNetworkManager;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.c2s.ImageUploadPayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingDeletePayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingEditPayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingRegisterPayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.resources.FrameLoader;
import net.conczin.immersive_paintings.util.ImageManipulations;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.util.TriConsumer;

public class ImmersivePaintingScreen
extends Screen {
    private static final int SCREENSHOTS_PER_PAGE = 5;
    final int minResolution;
    final int maxResolution;
    final boolean showOtherPlayersPaintings;
    final int uploadPermissionLevel;
    public final ImmersivePaintingEntity entity;
    private String filteredString = "";
    private int filteredResolution = 0;
    private int filteredWidth = 0;
    private int filteredHeight = 0;
    private final List<ResourceLocation> filteredPaintings = new ArrayList<ResourceLocation>();
    private int selectionPage;
    private Page page;
    private Button pageWidget;
    private final Map<ResourceLocation, PaintingWidget> paintingWidgets = new HashMap<ResourceLocation, PaintingWidget>();
    private BufferedImage currentImage;
    private static int currentImagePixelZoomCache = -1;
    private String currentImageName;
    private PixelatorSettings settings;
    private BufferedImage pixelatedImage;
    private List<File> screenshots = List.of();
    private int screenshotPage;
    private ResourceLocation deletePainting;
    private Component error;
    private boolean shouldReProcess;
    private static volatile boolean shouldUpload;
    private static final ExecutorService service;

    public ImmersivePaintingScreen(int entityId, int minResolution, int maxResolution, boolean showOtherPlayersPaintings, int uploadPermissionLevel) {
        super((Component)Component.translatable((String)"item.immersive_paintings.painting"));
        ImmersivePaintingEntity painting;
        Entity entity;
        this.minResolution = minResolution;
        this.maxResolution = maxResolution;
        this.showOtherPlayersPaintings = showOtherPlayersPaintings && Configs.CLIENT.showOtherPlayersPaintings;
        this.uploadPermissionLevel = uploadPermissionLevel;
        this.entity = Minecraft.getInstance().level != null && (entity = Minecraft.getInstance().level.getEntity(entityId)) instanceof ImmersivePaintingEntity ? (painting = (ImmersivePaintingEntity)entity) : null;
        if (this.entity == null) {
            this.onClose();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        super.init();
        if (this.page == null) {
            this.setPage(Page.DATAPACKS);
        } else {
            this.refreshPage();
        }
        File file = new File(Minecraft.getInstance().gameDirectory, "screenshots");
        File[] files = file.listFiles(v -> v.getName().endsWith(".png"));
        if (files != null) {
            this.screenshots = Arrays.stream(files).toList();
        }
    }

    private void clearSearch() {
        this.filteredString = "";
        this.filteredResolution = 0;
        this.filteredWidth = 0;
        this.filteredHeight = 0;
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.render(graphics, mouseX, mouseY, delta);
        switch (this.page.ordinal()) {
            case 3: {
                graphics.fill(this.width / 2 - 115, this.height / 2 - 68, this.width / 2 + 115, this.height / 2 - 41, 0x50000000);
                List<Component> wrap = ImmersivePaintingScreen.wrap((Component)Component.translatable((String)"immersive_paintings.gui.drop"), 220);
                int y = this.height / 2 - 40 - wrap.size() * 12;
                for (Component text : wrap) {
                    graphics.drawCenteredString(this.font, text, this.width / 2, y, -1);
                    y += 12;
                }
                break;
            }
            case 4: {
                if (this.shouldReProcess && this.currentImage != null) {
                    service.submit(() -> this.pixelateImage());
                    this.shouldReProcess = false;
                }
                if (shouldUpload && this.pixelatedImage != null) {
                    Minecraft.getInstance().getTextureManager().register(Main.locate("temp_pixelated"), (AbstractTexture)new DynamicTexture(ImageManipulations.bufferedToNative(this.pixelatedImage)));
                }
                int maxWidth = 190;
                int maxHeight = 135;
                int tw = this.settings.resolution * this.settings.width;
                int th = this.settings.resolution * this.settings.height;
                float size = Math.min((float)maxWidth / (float)tw, (float)maxHeight / (float)th);
                PoseStack poseStack = graphics.pose();
                poseStack.pushPose();
                poseStack.translate((float)this.width / 2.0f - (float)tw * size / 2.0f, (float)this.height / 2.0f - (float)th * size / 2.0f, 0.0f);
                poseStack.scale(size, size, 1.0f);
                graphics.blit(Main.locate("temp_pixelated"), 0, 0, 0.0f, 0.0f, tw, th, tw, th);
                poseStack.popPose();
                if (this.error == null) break;
                graphics.drawCenteredString(this.font, this.error, this.width / 2, this.height / 2, -65536);
                break;
            }
            case 6: {
                graphics.fill(this.width / 2 - 160, this.height / 2 - 50, this.width / 2 + 160, this.height / 2 + 50, -2013265920);
                List<Component> wrap = ImmersivePaintingScreen.wrap((Component)Component.translatable((String)"immersive_paintings.gui.confirm_deletion"), 300);
                int y = this.height / 2 - 35;
                for (Component t : wrap) {
                    graphics.drawCenteredString(this.font, t, this.width / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case 7: {
                graphics.fill(this.width / 2 - 160, this.height / 2 - 50, this.width / 2 + 160, this.height / 2 + 50, -2013265920);
                List<Component> wrap = ImmersivePaintingScreen.wrap((Component)Component.translatable((String)"immersive_paintings.gui.confirm_admin_deletion"), 300);
                int y = this.height / 2 - 35;
                for (Component t : wrap) {
                    graphics.drawCenteredString(this.font, t, this.width / 2, y, 0xFFFFFF);
                    y += 15;
                }
                break;
            }
            case 8: {
                MutableComponent text = Component.translatable((String)"immersive_paintings.gui.upload", (Object[])new Object[]{(int)Math.ceil(LazyNetworkManager.getRemainingTime())});
                graphics.drawCenteredString(this.font, (Component)text, this.width / 2, this.height / 2, -1);
            }
        }
    }

    private List<ResourceLocation> getMaterialsList(ResourceLocation frame) {
        return FrameLoader.frames.values().stream().filter(v -> v.frame().equals((Object)frame)).map(FrameLoader.Frame::material).distinct().sorted(ResourceLocation::compareTo).toList();
    }

    private void rebuild() {
        int x;
        this.clearWidgets();
        if (this.page != Page.CREATE) {
            LinkedList<Page> b = new LinkedList<Page>();
            b.add(Page.YOURS);
            b.add(Page.DATAPACKS);
            if (this.showOtherPlayersPaintings || this.isOp()) {
                b.add(Page.PLAYERS);
            }
            if (Minecraft.getInstance().player == null || Minecraft.getInstance().player.hasPermissions(this.uploadPermissionLevel)) {
                b.add(Page.NEW);
            }
            if (!this.entity.isGraffiti()) {
                b.add(Page.FRAME);
            }
            x = this.width / 2 - 200;
            int w2 = 400 / b.size();
            for (Page page : b) {
                Button btn = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)("immersive_paintings.gui.page." + page.name().toLowerCase(Locale.ROOT))), sender -> this.setPage(page)).bounds(x, this.height / 2 - 90 - 22, w2, 20).build());
                btn.active = page != this.page;
                x += w2;
            }
        }
        switch (this.page.ordinal()) {
            case 3: {
                EditBox editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 90, this.height / 2 - 38, 180, 16, (Component)Component.literal((String)"URL")));
                editBox.setMaxLength(1024);
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.load"), sender -> this.loadImage(editBox.getValue())).bounds(this.width / 2 - 50, this.height / 2 - 15, 100, 20).build());
                this.rebuildScreenshots();
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<<"), sender -> this.setScreenshotPage(this.screenshotPage - 1)).bounds(this.width / 2 - 65, this.height / 2 + 70, 30, 20).build());
                this.pageWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), sender -> {}).bounds(this.width / 2 - 65 + 30, this.height / 2 + 70, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">>"), sender -> this.setScreenshotPage(this.screenshotPage + 1)).bounds(this.width / 2 - 65 + 100, this.height / 2 + 70, 30, 20).build());
                this.setScreenshotPage(this.screenshotPage);
                break;
            }
            case 4: {
                EditBox editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 90, this.height / 2 - 100, 180, 20, (Component)Component.translatable((String)"immersive_paintings.gui.name")));
                editBox.setMaxLength(256);
                editBox.setValue(this.currentImageName);
                editBox.setResponder(s -> {
                    this.currentImageName = s;
                });
                int y = this.height / 2 - 60;
                this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget(this.width / 2 - 200, y, 100, 20, "immersive_paintings.gui.width", (double)this.settings.width, 1, 16, v -> {
                    this.settings.width = v;
                    this.shouldReProcess = true;
                }));
                this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget(this.width / 2 - 200, y += 22, 100, 20, "immersive_paintings.gui.height", (double)this.settings.height, 1, 16, v -> {
                    this.settings.height = v;
                    this.shouldReProcess = true;
                }));
                int x2 = this.width / 2 - 200;
                Button resolutionWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)String.valueOf(this.settings.resolution)), sender -> {}).pos(x2 + 25, y += 22).size(50, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.resolution"))).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), sender -> {
                    this.settings.resolution = Math.max(this.minResolution, this.settings.resolution / 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    resolutionWidget.setMessage((Component)Component.literal((String)String.valueOf(this.settings.resolution)));
                }).pos(x2, y).size(25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.resolution"))).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), sender -> {
                    this.settings.resolution = Math.min(this.maxResolution, this.settings.resolution * 2);
                    if (this.settings.pixelArt) {
                        this.adaptToPixelArt();
                        this.refreshPage();
                    }
                    this.shouldReProcess = true;
                    resolutionWidget.setMessage((Component)Component.literal((String)String.valueOf(this.settings.resolution)));
                }).pos(x2 + 75, y).size(25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.resolution"))).build());
                y += 22;
                ((IntegerSliderWidget)this.addRenderableWidget((GuiEventListener)new IntegerSliderWidget((int)(this.width / 2 - 200), (int)(y += 10), (int)100, (int)20, (String)"immersive_paintings.gui.colors", (double)((double)this.settings.colors), (int)2, (int)25, (Consumer<Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$14(java.lang.Integer ), (Ljava/lang/Integer;)V)((ImmersivePaintingScreen)this)))).active = !this.settings.pixelArt;
                ((PercentageSliderWidget)this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget((int)(this.width / 2 - 200), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.gui.dither", (double)this.settings.dither, (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$15(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).active = !this.settings.pixelArt;
                y = this.height / 2 - 50;
                this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"immersive_paintings.gui.pixelart"), (Font)this.font).pos(this.width / 2 + 100, y).selected(this.settings.pixelArt).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.pixelart.tooltip"))).onValueChange((w, v) -> {
                    this.settings.pixelArt = v;
                    this.adaptToPixelArt();
                    this.refreshPage();
                    this.shouldReProcess = true;
                }).build());
                this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"immersive_paintings.gui.hide"), (Font)this.font).pos(this.width / 2 + 100, y += 22).selected(this.settings.hidden).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.visibility"))).onValueChange((w, v) -> {
                    this.settings.hidden = !this.settings.hidden;
                }).build());
                this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.translatable((String)"immersive_paintings.gui.nsfw"), (Font)this.font).pos(this.width / 2 + 100, y += 22).selected(this.settings.nsfw).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.nsfw"))).onValueChange((w, v) -> {
                    this.settings.nsfw = !this.settings.nsfw;
                }).build());
                this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget(this.width / 2 + 100, y += 22, 100, 20, "immersive_paintings.gui.x_offset", this.settings.offsetX, v -> {
                    this.settings.offsetX = v;
                    this.shouldReProcess = true;
                }));
                this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget(this.width / 2 + 100, y += 22, 100, 20, "immersive_paintings.gui.y_offset", this.settings.offsetY, v -> {
                    this.settings.offsetY = v;
                    this.shouldReProcess = true;
                }));
                ((PercentageSliderWidget)this.addRenderableWidget((GuiEventListener)new PercentageSliderWidget((int)(this.width / 2 + 100), (int)(y += 22), (int)100, (int)20, (String)"immersive_paintings.gui.zoom", (double)this.settings.zoom, (double)(this.entity.isGraffiti() ? 0.5 : 1.0), (double)(this.entity.isGraffiti() ? 1.5 : 3.0), (Consumer<Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$rebuild$21(java.lang.Double ), (Ljava/lang/Double;)V)((ImmersivePaintingScreen)this)))).active = !this.settings.pixelArt;
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.cancel"), v -> this.setPage(Page.NEW)).bounds(this.width / 2 - 85, this.height / 2 + 75, 80, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.save"), v -> {
                    byte[] encoded;
                    try {
                        encoded = ImageManipulations.encode(this.pixelatedImage);
                    }
                    catch (IOException e) {
                        Main.LOGGER.error("could not encode temp image", (Throwable)e);
                        return;
                    }
                    ImageManipulations.processByteArrayInChunks(encoded, (TriConsumer<byte[], Integer, Integer>)((TriConsumer)(ints, split, splits) -> LazyNetworkManager.sendToServer(new ImageUploadPayload((byte[])ints, (int)split, (int)splits))));
                    EnumSet<Painting.Flag> flags = this.settings.getFlags();
                    if (this.entity.isGraffiti()) {
                        flags.add(Painting.Flag.GRAFFITI);
                    }
                    LazyNetworkManager.sendToServer(new PaintingRegisterPayload(this.settings.width, this.settings.height, this.settings.resolution, this.currentImageName, flags));
                    this.setPage(Page.LOADING);
                }).bounds(this.width / 2 + 5, this.height / 2 + 75, 80, 20).build());
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.rebuildPaintings();
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<<"), sender -> this.setSelectionPage(this.selectionPage - 1)).bounds(this.width / 2 - 35 - 30, this.height / 2 + 80, 30, 20).build());
                this.pageWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)""), sender -> {}).bounds(this.width / 2 - 35, this.height / 2 + 80, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">>"), sender -> this.setSelectionPage(this.selectionPage + 1)).bounds(this.width / 2 + 35, this.height / 2 + 80, 30, 20).build());
                this.setSelectionPage(this.selectionPage);
                EditBox editBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 65, this.height / 2 - 88, 130, 16, (Component)Component.translatable((String)"immersive_paintings.gui.search")));
                editBox.setMaxLength(64);
                editBox.setSuggestion("search");
                editBox.setResponder(s -> {
                    this.filteredString = s;
                    this.updateSearch();
                    editBox.setSuggestion(null);
                });
                x = this.width / 2 - 200 + 12;
                Button widget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)String.valueOf(this.filteredResolution)), sender -> {}).pos(x + 50 + 8, this.height / 2 - 90).size(25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                Button allWidget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.filter_all"), sender -> {
                    this.filteredResolution = 0;
                    this.updateSearch();
                    widget.setMessage((Component)Component.literal((String)String.valueOf(this.filteredResolution)));
                    sender.active = false;
                }).pos(x, this.height / 2 - 90).size(25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"<"), sender -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.max(this.minResolution, this.filteredResolution / 2);
                    this.updateSearch();
                    widget.setMessage((Component)Component.literal((String)String.valueOf(this.filteredResolution)));
                    allWidget.active = true;
                }).pos(x + 25 + 8, this.height / 2 - 90).size(25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)">"), sender -> {
                    this.filteredResolution = this.filteredResolution == 0 ? 32 : Math.min(this.maxResolution, this.filteredResolution * 2);
                    this.updateSearch();
                    widget.setMessage((Component)Component.literal((String)String.valueOf(this.filteredResolution)));
                    allWidget.active = true;
                }).pos(x + 75 + 8, this.height / 2 - 90).size(25, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"immersive_paintings.gui.tooltip.filter_resolution"))).build());
                EditBox widthWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 + 80, this.height / 2 - 88, 40, 16, (Component)Component.translatable((String)"immersive_paintings.gui.filter_width")));
                widthWidget.setMaxLength(2);
                widthWidget.setSuggestion("width");
                widthWidget.setResponder(s -> {
                    try {
                        this.filteredWidth = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredWidth = 0;
                    }
                    this.updateSearch();
                    widthWidget.setSuggestion(null);
                });
                EditBox heightWidget = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.width / 2 + 80 + 40, this.height / 2 - 88, 40, 16, (Component)Component.translatable((String)"immersive_paintings.gui.filter_height")));
                heightWidget.setMaxLength(2);
                heightWidget.setSuggestion("height");
                heightWidget.setResponder(s -> {
                    try {
                        this.filteredHeight = Integer.parseInt(s);
                    }
                    catch (NumberFormatException ignored) {
                        this.filteredHeight = 0;
                    }
                    this.updateSearch();
                    heightWidget.setSuggestion(null);
                });
                break;
            }
            case 5: {
                int y = this.height / 2 - 80;
                List<ResourceLocation> frames = FrameLoader.frames.values().stream().map(FrameLoader.Frame::frame).distinct().sorted(ResourceLocation::compareTo).toList();
                for (ResourceLocation frame : frames) {
                    Button widget = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)("immersive_paintings.frame." + ImmersivePaintingScreen.identifierToTranslation(frame))), v -> {
                        ResourceLocation material = this.getMaterialsList(frame).getFirst();
                        this.entity.setFrame(frame);
                        this.entity.setMaterial(material);
                        NetworkHandler.Client.sendToServer(new PaintingEditPayload(this.entity.getId(), Map.of(PaintingEditPayload.Option.FRAME, frame.toString(), PaintingEditPayload.Option.MATERIAL, material.toString())));
                        this.setPage(Page.FRAME);
                    }).bounds(this.width / 2 - 200, y, 100, 20).build());
                    widget.active = !frame.equals((Object)this.entity.getFrame());
                    y += 25;
                }
                int py = 0;
                int px = 0;
                List<ResourceLocation> materials = this.getMaterialsList(this.entity.getFrame());
                LinkedList<Button> materialList = new LinkedList<Button>();
                for (ResourceLocation material : materials) {
                    Button widget = (Button)this.addRenderableWidget((GuiEventListener)new TexturedButtonWidget(this.width / 2 - 80 + px * 65, this.height / 2 - 80 + py * 20, 64, 16, ResourceLocation.fromNamespaceAndPath((String)material.getNamespace(), (String)material.getPath().replace("/block/", "/gui/")), 64, 32, (Component)Component.literal((String)""), v -> {
                        this.entity.setMaterial(material);
                        NetworkHandler.Client.sendToServer(new PaintingEditPayload(this.entity.getId(), Map.of(PaintingEditPayload.Option.MATERIAL, material.toString())));
                        materialList.forEach(b -> {
                            b.active = true;
                        });
                        v.active = false;
                    }));
                    Tooltip paintingTooltip = Tooltip.create((Component)Component.translatable((String)("immersive_paintings.material." + ImmersivePaintingScreen.identifierToTranslation(material))));
                    widget.setTooltip(paintingTooltip);
                    widget.active = !material.equals((Object)this.entity.getMaterial());
                    materialList.add(widget);
                    if (++px <= 3) continue;
                    px = 0;
                    ++py;
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.done"), v -> this.onClose()).bounds(this.width / 2 - 50, this.height / 2 + 70, 100, 20).build());
                break;
            }
            case 6: {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.cancel"), v -> this.setPage(Page.YOURS)).bounds(this.width / 2 - 100 - 5, this.height / 2 + 20, 100, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.delete"), v -> {
                    NetworkHandler.Client.sendToServer(new PaintingDeletePayload(this.deletePainting, false));
                    this.setPage(Page.YOURS);
                }).bounds(this.width / 2 + 5, this.height / 2 + 20, 100, 20).build());
                break;
            }
            case 7: {
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.cancel"), v -> this.setPage(Page.PLAYERS)).bounds(this.width / 2 - 115, this.height / 2 + 10, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.delete"), v -> {
                    NetworkHandler.Client.sendToServer(new PaintingDeletePayload(this.deletePainting, false));
                    this.setPage(Page.PLAYERS);
                }).bounds(this.width / 2 - 40, this.height / 2 + 10, 70, 20).build());
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"immersive_paintings.gui.delete_all"), v -> {
                    NetworkHandler.Client.sendToServer(new PaintingDeletePayload(this.deletePainting, true));
                    this.setPage(Page.PLAYERS);
                }).bounds(this.width / 2 + 35, this.height / 2 + 10, 70, 20).build());
            }
        }
    }

    public void updateWidget(ResourceLocation identifier) {
        if (this.paintingWidgets.containsKey(identifier)) {
            ClientPaintingManager.getPainting(identifier).ifPresent(p -> this.paintingWidgets.get(identifier).update(ClientPaintingManager.getImageIdentifier(identifier, Painting.Size.THUMBNAIL), p.width(), p.height()));
        }
    }

    public static String identifierToTranslation(ResourceLocation location) {
        String s = location.getPath();
        String lastSplit = s.substring(s.lastIndexOf("/") + 1);
        int i = lastSplit.lastIndexOf(".");
        return i < 0 ? lastSplit : lastSplit.substring(0, i);
    }

    public static List<Component> wrap(Component text, int maxWidth) {
        return Minecraft.getInstance().font.getSplitter().splitLines((FormattedText)text, maxWidth, Style.EMPTY).stream().map(line -> {
            MutableComponent compiled = Component.literal((String)"");
            line.visit((s, t) -> {
                compiled.append((Component)Component.literal((String)t).setStyle(s));
                return Optional.empty();
            }, text.getStyle());
            return compiled;
        }).collect(Collectors.toList());
    }

    private static Component consolidate(List<Component> textList) {
        if (textList == null) {
            return null;
        }
        MutableComponent base = Component.empty();
        MutableComponent lastTextNode = base.copy();
        if (textList.isEmpty()) {
            return base;
        }
        for (int i = 0; i < textList.size() - 1; ++i) {
            Component text = textList.get(i);
            lastTextNode = lastTextNode.append(text).append("\n");
        }
        Component finalElement = textList.getLast();
        return lastTextNode.append(finalElement);
    }

    private void rebuildPaintings() {
        this.paintingWidgets.forEach((id, widget) -> this.removeWidget((GuiEventListener)widget));
        this.paintingWidgets.clear();
        for (int y = 0; y < 3; ++y) {
            int i;
            for (int x = 0; x < 8 && (i = y * 8 + x + this.selectionPage * 24) >= 0 && i < this.filteredPaintings.size(); ++x) {
                ResourceLocation identifier = this.filteredPaintings.get(i);
                LinkedList<Component> tooltip = new LinkedList<Component>();
                ClientPaintingManager.getPainting(identifier).ifPresent(p -> {
                    tooltip.add((Component)Component.literal((String)p.name()));
                    tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.by_author", (Object[])new Object[]{p.author()}).withStyle(ChatFormatting.ITALIC));
                    tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.resolution", (Object[])new Object[]{p.width(), p.height(), p.resolution()}).withStyle(ChatFormatting.ITALIC));
                    if (this.page == Page.YOURS && p.has(Painting.Flag.HIDDEN)) {
                        tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.hidden").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                    if (this.page == Page.YOURS && p.has(Painting.Flag.NSFW)) {
                        tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.nsfw").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                    if (this.page == Page.YOURS || this.page == Page.PLAYERS && this.isOp()) {
                        tooltip.add((Component)Component.translatable((String)"immersive_paintings.gui.right_click_to_delete").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                    }
                });
                PaintingWidget paintingWidget = (PaintingWidget)this.addRenderableWidget((GuiEventListener)new PaintingWidget((int)((double)this.width / 2.0 + ((double)x - 3.5) * 48.0) - 24, this.height / 2 - 66 + y * 48, 46, 46, sender -> {
                    NetworkHandler.Client.sendToServer(new PaintingEditPayload(this.entity.getId(), Map.of(PaintingEditPayload.Option.MOTIVE, identifier.toString())));
                    if (this.entity.isGraffiti()) {
                        this.onClose();
                    } else {
                        this.setPage(Page.FRAME);
                    }
                }, sender -> {
                    if (this.page == Page.YOURS) {
                        this.deletePainting = identifier;
                        this.setPage(Page.DELETE);
                    } else if (this.page == Page.PLAYERS && this.isOp()) {
                        this.deletePainting = identifier;
                        this.setPage(Page.ADMIN_DELETE);
                    }
                }));
                paintingWidget.setTooltip(Tooltip.create((Component)ImmersivePaintingScreen.consolidate(tooltip)));
                this.paintingWidgets.put(identifier, paintingWidget);
                this.updateWidget(identifier);
            }
        }
    }

    private void rebuildScreenshots() {
        int i;
        this.paintingWidgets.forEach((id, widget) -> this.removeWidget((GuiEventListener)widget));
        this.paintingWidgets.clear();
        for (int x = 0; x < 5 && (i = x + this.screenshotPage * 5) >= 0 && i < this.screenshots.size(); ++x) {
            File file = this.screenshots.get(i);
            PaintingWidget paintingWidget = (PaintingWidget)this.addRenderableWidget((GuiEventListener)new PaintingWidget(this.width / 2 + (x - 2) * 68 - 32, this.height / 2 + 15, 64, 48, b -> {
                this.currentImage = ((PaintingWidget)b).getImage();
                if (this.currentImage != null) {
                    currentImagePixelZoomCache = -1;
                    this.currentImageName = file.getName();
                    this.settings = new PixelatorSettings(this.currentImage, this.minResolution, this.maxResolution);
                    this.setPage(Page.CREATE);
                    this.pixelateImage();
                }
            }, b -> {}));
            paintingWidget.setTooltip(Tooltip.create((Component)Component.literal((String)file.getName())));
            ResourceLocation identifier = Main.locate("screenshot_" + x);
            this.paintingWidgets.put(identifier, paintingWidget);
            service.submit(() -> {
                BufferedImage image = this.loadImage(file.getPath(), identifier);
                if (image != null) {
                    paintingWidget.update(identifier, image);
                }
            });
        }
    }

    public void setPage(Page page) {
        if (page != this.page) {
            this.clearSearch();
        }
        this.page = page;
        this.filteredResolution = page == Page.DATAPACKS ? 32 : 0;
        this.rebuild();
        if (page == Page.DATAPACKS || page == Page.PLAYERS || page == Page.YOURS) {
            this.updateSearch();
        }
    }

    private void updateSearch() {
        this.filteredPaintings.clear();
        LocalPlayer player = Minecraft.getInstance().player;
        UUID uuid = player == null ? null : player.getUUID();
        this.filteredPaintings.addAll(ClientPaintingManager.getPaintings().entrySet().stream().filter(e -> {
            Painting p = (Painting)e.getValue();
            return !((this.page != Page.YOURS || p.is(Painting.Type.DATAPACK) || !p.authorUUID().equals(uuid)) && (this.page != Page.PLAYERS || p.is(Painting.Type.DATAPACK) || p.has(Painting.Flag.HIDDEN) && !this.isOp() || p.has(Painting.Flag.NSFW) && !Configs.CLIENT.showNSFWPaintings && !this.isOp()) && (this.page != Page.DATAPACKS || !p.is(Painting.Type.DATAPACK)) || p.has(Painting.Flag.GRAFFITI) != this.entity.isGraffiti() || !((ResourceLocation)e.getKey()).toString().contains(this.filteredString) || this.filteredResolution != 0 && p.resolution() != this.filteredResolution || this.filteredWidth != 0 && p.width() != this.filteredWidth || this.filteredHeight != 0 && p.height() != this.filteredHeight);
        }).sorted(Comparator.comparing(p -> ((Painting)p.getValue()).name())).map(Map.Entry::getKey).toList());
        this.setSelectionPage(this.selectionPage);
    }

    private boolean isOp() {
        return Minecraft.getInstance().player != null && Minecraft.getInstance().player.hasPermissions(4);
    }

    private void setSelectionPage(int p) {
        int maxPages = (int)Math.ceil((double)this.filteredPaintings.size() / 24.0);
        this.selectionPage = Math.min(maxPages - 1, Math.max(0, p));
        this.rebuildPaintings();
        this.pageWidget.setMessage((Component)Component.literal((String)(this.selectionPage + 1 + " / " + maxPages)));
    }

    private void setScreenshotPage(int p) {
        int maxPages = (int)Math.ceil((double)this.screenshots.size() / 8.0);
        int oldPage = this.screenshotPage;
        this.screenshotPage = Math.min(maxPages - 1, Math.max(0, p));
        if (oldPage != this.screenshotPage) {
            this.rebuildScreenshots();
        }
        this.pageWidget.setMessage((Component)Component.literal((String)(this.screenshotPage + 1 + " / " + maxPages)));
    }

    public void onFilesDrop(List<Path> paths) {
        this.loadImage(paths.getFirst().toString());
    }

    private void loadImage(String path) {
        this.currentImage = this.loadImage(path, Main.locate("temp"));
        currentImagePixelZoomCache = -1;
        if (this.currentImage != null) {
            this.currentImageName = FilenameUtils.getBaseName((String)path).replaceFirst("[.][^.]+$", "");
            this.settings = new PixelatorSettings(this.currentImage, this.minResolution, this.maxResolution);
            this.setPage(Page.CREATE);
            this.pixelateImage();
        }
    }

    private BufferedImage loadImage(String path, ResourceLocation identifier) {
        InputStream stream = null;
        try {
            stream = new URL(path).openStream();
        }
        catch (Exception exception) {
            try {
                stream = new FileInputStream(path);
            }
            catch (Exception e) {
                Main.LOGGER.error("failed loading image {} from path {}", (Object)identifier, (Object)path, (Object)e);
            }
        }
        if (stream != null) {
            try {
                BufferedImage image = ImageIO.read(stream);
                if (image != null) {
                    this.preprocessImage(image);
                    Minecraft.getInstance().getTextureManager().register(identifier, (AbstractTexture)new DynamicTexture(ImageManipulations.bufferedToNative(image)));
                    stream.close();
                    return image;
                }
            }
            catch (IOException e) {
                Main.LOGGER.error("failed decoding image {} from path {}", (Object)identifier, (Object)path, (Object)e);
            }
        }
        return null;
    }

    private void preprocessImage(BufferedImage image) {
        this.clearError();
        if (!this.entity.isGraffiti()) {
            for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    int color = image.getRGB(x, y);
                    int alpha = color >> 24 & 0xFF;
                    if (alpha == 255) continue;
                    if (this.error == null) {
                        this.setError((Component)Component.translatable((String)"immersive_paintings.gui.graffiti_warning"));
                    }
                    color = 0xFF000000 | color & 0xFFFFFF;
                    image.setRGB(x, y, color);
                }
            }
        }
    }

    private static int getCurrentImagePixelZoomCache(BufferedImage currentImage) {
        if (currentImagePixelZoomCache < 0) {
            currentImagePixelZoomCache = ImageManipulations.scanForPixelArtMultiple(currentImage);
        }
        return currentImagePixelZoomCache;
    }

    private void adaptToPixelArt() {
        double zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(this.currentImage);
        this.settings.width = Math.max(1, Math.min(16, (int)((double)this.currentImage.getWidth() / zoom / (double)this.settings.resolution)));
        this.settings.height = Math.max(1, Math.min(16, (int)((double)this.currentImage.getHeight() / zoom / (double)this.settings.resolution)));
    }

    private void pixelateImage() {
        this.pixelatedImage = ImmersivePaintingScreen.pixelateImage(this.currentImage, this.settings);
        shouldUpload = true;
    }

    public static BufferedImage pixelateImage(BufferedImage currentImage, PixelatorSettings settings) {
        float zoom;
        BufferedImage pixelatedImage = new BufferedImage(settings.resolution * settings.width, settings.resolution * settings.height, 2);
        if (settings.pixelArt) {
            zoom = ImmersivePaintingScreen.getCurrentImagePixelZoomCache(currentImage);
        } else {
            float fx = (float)currentImage.getWidth() / (float)pixelatedImage.getWidth();
            float fy = (float)currentImage.getHeight() / (float)pixelatedImage.getHeight();
            zoom = (float)((double)Math.min(fx, fy) / settings.zoom);
        }
        int ox = (int)((double)((float)currentImage.getWidth() - (float)pixelatedImage.getWidth() * zoom) * settings.offsetX);
        int oy = (int)((double)((float)currentImage.getHeight() - (float)pixelatedImage.getHeight() * zoom) * settings.offsetY);
        if (settings.pixelArt) {
            ox = ox / (int)zoom * (int)zoom;
            oy = oy / (int)zoom * (int)zoom;
        }
        ImageManipulations.resize(pixelatedImage, currentImage, zoom, ox, oy);
        if (settings.dither > 0.0 && !settings.pixelArt) {
            if (settings.colors > 1) {
                ImageManipulations.dither(pixelatedImage, settings.dither / (double)settings.colors);
            } else {
                ImageManipulations.dither(pixelatedImage, settings.dither / 16.0);
            }
        }
        if (settings.colors > 1 && !settings.pixelArt) {
            ImageManipulations.reduceColors(pixelatedImage, settings.colors);
        }
        return pixelatedImage;
    }

    public void refreshPage() {
        this.setPage(this.page);
    }

    public void clearError() {
        this.error = null;
    }

    public void setError(Component text) {
        this.error = text;
    }

    private /* synthetic */ void lambda$rebuild$21(Double v) {
        this.settings.zoom = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$15(Double v) {
        this.settings.dither = v;
        this.shouldReProcess = true;
    }

    private /* synthetic */ void lambda$rebuild$14(Integer v) {
        this.settings.colors = v;
        this.shouldReProcess = true;
    }

    static {
        service = Executors.newFixedThreadPool(1);
    }

    public static enum Page {
        YOURS,
        DATAPACKS,
        PLAYERS,
        NEW,
        CREATE,
        FRAME,
        DELETE,
        ADMIN_DELETE,
        LOADING;

    }

    public static final class PixelatorSettings {
        public double dither;
        public int colors;
        public int resolution;
        public int width;
        public int height;
        public double offsetX;
        public double offsetY;
        public double zoom;
        public boolean pixelArt;
        public boolean hidden = true;
        public boolean nsfw;

        public PixelatorSettings(double dither, int colors, int resolution, int width, int height, double offsetX, double offsetY, double zoom, boolean pixelArt) {
            this.dither = dither;
            this.colors = colors;
            this.resolution = resolution;
            this.width = width;
            this.height = height;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.zoom = zoom;
            this.pixelArt = pixelArt;
        }

        PixelatorSettings(BufferedImage currentImage, int minResolution, int maxResolution) {
            this(0.0, 10, Math.clamp(64L, minResolution, maxResolution), 1, 1, 0.5, 0.5, 1.0, false);
            double target = (double)currentImage.getWidth() / (double)currentImage.getHeight();
            double bestScore = 100.0;
            double d = Math.sqrt(currentImage.getWidth() * currentImage.getWidth() + currentImage.getHeight() * currentImage.getHeight());
            double dw = (double)currentImage.getWidth() / d;
            double dh = (double)currentImage.getHeight() / d;
            for (double diagonal = 3.0; diagonal < 6.0; diagonal += target) {
                int ph;
                int pw = (int)Math.ceil(dw * diagonal);
                double e = Math.abs((double)pw / (double)(ph = (int)Math.ceil(dh * diagonal)) - target) * Math.sqrt(5 + this.width + this.height);
                if (!(e < bestScore)) continue;
                this.width = Math.max(1, Math.min(16, pw));
                this.height = Math.max(1, Math.min(16, ph));
                bestScore = e;
            }
        }

        public EnumSet<Painting.Flag> getFlags() {
            EnumSet<Painting.Flag> flags = EnumSet.noneOf(Painting.Flag.class);
            if (this.nsfw) {
                flags.add(Painting.Flag.NSFW);
            }
            if (this.hidden) {
                flags.add(Painting.Flag.HIDDEN);
            }
            return flags;
        }
    }
}

