/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.core.util;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ColorUtils {
    public static int scaleRGB(int color, float red, float green, float blue) {
        return FastColor.ARGB32.color((int)FastColor.ARGB32.alpha((int)color), (int)Mth.clamp((int)((int)((float)FastColor.ARGB32.red((int)color) * red)), (int)0, (int)255), (int)Mth.clamp((int)((int)((float)FastColor.ARGB32.green((int)color) * green)), (int)0, (int)255), (int)Mth.clamp((int)((int)((float)FastColor.ARGB32.blue((int)color) * blue)), (int)0, (int)255));
    }

    public static int colorFromFloat(float alpha, float red, float green, float blue) {
        return FastColor.ARGB32.color((int)((int)(alpha * 255.0f)), (int)((int)(red * 255.0f)), (int)((int)(green * 255.0f)), (int)((int)(blue * 255.0f)));
    }

    public static DyeColor getMixedColor(ServerLevel level, DyeColor colorA, DyeColor colorB) {
        CraftingInput container = ColorUtils.makeCraftColorInput(colorA, colorB);
        return level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)container, (Level)level).map(recipe -> ((CraftingRecipe)recipe.value()).assemble((RecipeInput)container, (HolderLookup.Provider)level.registryAccess())).map(ItemStack::getItem).filter(DyeItem.class::isInstance).map(DyeItem.class::cast).map(DyeItem::getDyeColor).orElseGet(() -> level.random.nextBoolean() ? colorA : colorB);
    }

    private static CraftingInput makeCraftColorInput(DyeColor colorA, DyeColor colorB) {
        return CraftingInput.of((int)2, (int)1, List.of(new ItemStack((ItemLike)DyeItem.byColor((DyeColor)colorA)), new ItemStack((ItemLike)DyeItem.byColor((DyeColor)colorB))));
    }
}

