/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.vanillabackport.client.level.entities.variant;

import com.blackgear.vanillabackport.client.level.entities.model.pig.ColdPigModel;
import com.blackgear.vanillabackport.client.registries.ModModelLayers;
import com.blackgear.vanillabackport.common.api.variant.VariantHolder;
import com.blackgear.vanillabackport.common.level.entities.animal.PigVariant;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Pig;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PigVariantRenderer {
    protected final Map<PigVariant.ModelType, PigModel<Pig>> modelByVariant;

    public PigVariantRenderer(EntityRendererProvider.Context context) {
        this.modelByVariant = this.bakeModels(context);
    }

    public Map<PigVariant.ModelType, PigModel<Pig>> bakeModels(EntityRendererProvider.Context context) {
        EnumMap map = Maps.newEnumMap(PigVariant.ModelType.class);
        map.put(PigVariant.ModelType.NORMAL, null);
        map.put(PigVariant.ModelType.COLD, new ColdPigModel(context.bakeLayer(ModModelLayers.COLD_PIG)));
        return map;
    }

    public ResourceLocation getTexture(Pig entity) {
        PigVariant variant = (PigVariant)VariantHolder.vb$getVariantHolder((LivingEntity)entity).vb$getVariant();
        return variant != null ? variant.modelAndTexture().asset().path() : null;
    }

    public Optional<PigModel<Pig>> getModel(Pig entity) {
        PigVariant variant = (PigVariant)VariantHolder.vb$getVariantHolder((LivingEntity)entity).vb$getVariant();
        return variant != null ? Optional.ofNullable(this.modelByVariant.get((Object)variant.modelAndTexture().model())) : Optional.empty();
    }
}

