/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousnether.init;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.luminousnether.init.LuminousNetherModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import terrablender.api.SurfaceRuleManager;

public class LuminousNetherModBiomes {
    private static final Logger LOGGER = LogManager.getLogger();

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        Registry dimensionTypeRegistry = server.registryAccess().registryOrThrow(Registries.DIMENSION_TYPE);
        Registry levelStemTypeRegistry = server.registryAccess().registryOrThrow(Registries.LEVEL_STEM);
        Registry biomeRegistry = server.registryAccess().registryOrThrow(Registries.BIOME);
        for (LevelStem levelStem : levelStemTypeRegistry.stream().toList()) {
            ArrayList<SurfaceRules.RuleSource> surfaceRules;
            ChunkGenerator chunkGenerator;
            BiomeSource biomeSource;
            DimensionType dimensionType = (DimensionType)levelStem.type().value();
            if (dimensionType != dimensionTypeRegistry.getOrThrow(BuiltinDimensionTypes.NETHER) || !((biomeSource = (chunkGenerator = levelStem.generator()).getBiomeSource()) instanceof MultiNoiseBiomeSource)) continue;
            MultiNoiseBiomeSource noiseSource = (MultiNoiseBiomeSource)biomeSource;
            ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters = new ArrayList<Pair<Climate.ParameterPoint, Holder<Biome>>>(noiseSource.parameters().values());
            ResourceLocation rlFungalPlains = ResourceLocation.tryParse((String)"luminous_nether:fungal_plains");
            if (rlFungalPlains == null) {
                throw new IllegalArgumentException("Invalid biome ID: luminous_nether:fungal_plains");
            }
            ResourceLocation rlAshForest = ResourceLocation.tryParse((String)"luminous_nether:ash_forest");
            if (rlAshForest == null) {
                throw new IllegalArgumentException("Invalid biome ID: luminous_nether:ash_forest");
            }
            Holder fungalPlainsHolder = (Holder)biomeRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rlFungalPlains)).orElseThrow(() -> new IllegalStateException("Fungal Plains biome missing from registry"));
            Holder ashForestHolder = (Holder)biomeRegistry.getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rlAshForest)).orElseThrow(() -> new IllegalStateException("Ash Forest biome missing from registry"));
            LuminousNetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.3f), Climate.Parameter.span((float)-0.8f, (float)-0.2f), Climate.Parameter.span((float)-0.2f, (float)1.5f), Climate.Parameter.span((float)-0.0f, (float)1.8f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-1.4001f, (float)-0.1f), 0L), (Object)fungalPlainsHolder));
            LuminousNetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)0.0f, (float)0.3f), Climate.Parameter.span((float)-0.8f, (float)-0.2f), Climate.Parameter.span((float)-0.2f, (float)1.5f), Climate.Parameter.span((float)-0.0f, (float)1.8f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-1.4001f, (float)-0.1f), 0L), (Object)fungalPlainsHolder));
            LuminousNetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)-0.8f), Climate.Parameter.span((float)-0.7f, (float)0.4f), Climate.Parameter.span((float)-0.2f, (float)1.2f), Climate.Parameter.span((float)0.3f, (float)1.68f), Climate.Parameter.point((float)0.0f), Climate.Parameter.span((float)-0.8154f, (float)0.5846f), 0L), (Object)ashForestHolder));
            LuminousNetherModBiomes.addParameterPoint(parameters, (Pair<Climate.ParameterPoint, Holder<Biome>>)new Pair((Object)new Climate.ParameterPoint(Climate.Parameter.span((float)-1.0f, (float)-0.8f), Climate.Parameter.span((float)-0.7f, (float)0.4f), Climate.Parameter.span((float)-0.2f, (float)1.2f), Climate.Parameter.span((float)0.3f, (float)1.68f), Climate.Parameter.point((float)1.0f), Climate.Parameter.span((float)-0.8154f, (float)0.5846f), 0L), (Object)ashForestHolder));
            chunkGenerator.biomeSource = MultiNoiseBiomeSource.createFromList((Climate.ParameterList)new Climate.ParameterList(parameters));
            chunkGenerator.featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(chunkGenerator.biomeSource.possibleBiomes()), biome -> ((BiomeGenerationSettings)chunkGenerator.generationSettingsGetter.apply(biome)).features(), (boolean)true));
            if (!(chunkGenerator instanceof NoiseBasedChunkGenerator)) continue;
            NoiseBasedChunkGenerator noiseGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            NoiseGeneratorSettings noiseGeneratorSettings = (NoiseGeneratorSettings)noiseGenerator.settings.value();
            SurfaceRules.RuleSource currentRuleSource = noiseGeneratorSettings.surfaceRule();
            if (currentRuleSource instanceof SurfaceRules.SequenceRuleSource) {
                SurfaceRules.SequenceRuleSource sequenceRuleSource = (SurfaceRules.SequenceRuleSource)currentRuleSource;
                surfaceRules = new ArrayList(sequenceRuleSource.sequence());
            } else {
                surfaceRules = new ArrayList<SurfaceRules.RuleSource>();
                surfaceRules.add(currentRuleSource);
            }
            LuminousNetherModBiomes.addSurfaceRule(surfaceRules, 2, LuminousNetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rlFungalPlains), ((Block)LuminousNetherModBlocks.GOLDEN_NYLIUM.get()).defaultBlockState(), ((Block)LuminousNetherModBlocks.FUNGIRRACK.get()).defaultBlockState(), ((Block)LuminousNetherModBlocks.FUNGIRRACK.get()).defaultBlockState()));
            LuminousNetherModBiomes.addSurfaceRule(surfaceRules, 2, LuminousNetherModBiomes.anySurfaceRule((ResourceKey<Biome>)ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)rlAshForest), ((Block)LuminousNetherModBlocks.SOLID_ASH.get()).defaultBlockState(), ((Block)LuminousNetherModBlocks.CHARRED_NETHERRACK.get()).defaultBlockState(), ((Block)LuminousNetherModBlocks.CHARRED_NETHERRACK.get()).defaultBlockState()));
            SurfaceRules.RuleSource mergedRule = SurfaceRules.sequence((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])surfaceRules.toArray(SurfaceRules.RuleSource[]::new)));
            if (!ModList.get().isLoaded("terrablender")) continue;
            SurfaceRuleManager.addSurfaceRules((SurfaceRuleManager.RuleCategory)SurfaceRuleManager.RuleCategory.NETHER, (String)"luminous_nether", (SurfaceRules.RuleSource)mergedRule);
        }
    }

    private static SurfaceRules.RuleSource anySurfaceRule(ResourceKey<Biome> biomeKey, BlockState groundBlock, BlockState undergroundBlock, BlockState underwaterBlock) {
        return SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{biomeKey}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.waterBlockCheck((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)groundBlock)), SurfaceRules.state((BlockState)underwaterBlock)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)0, (boolean)true, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.state((BlockState)undergroundBlock))}));
    }

    private static void addParameterPoint(List<Pair<Climate.ParameterPoint, Holder<Biome>>> parameters, Pair<Climate.ParameterPoint, Holder<Biome>> point) {
        if (!parameters.contains(point)) {
            parameters.add(point);
        }
    }

    private static void addSurfaceRule(List<SurfaceRules.RuleSource> surfaceRules, int index, SurfaceRules.RuleSource rule) {
        if (!surfaceRules.contains(rule)) {
            if (index >= surfaceRules.size()) {
                surfaceRules.add(rule);
            } else {
                surfaceRules.add(index, rule);
            }
        }
    }
}

