/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.luminousnether.block;

import net.mcreator.luminousnether.block.entity.LootVase10BlockEntity;
import net.mcreator.luminousnether.procedures.SoulVaseDestroyedProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LootVase10Block
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public LootVase10Block() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.DECORATED_POT).strength(0.2f, 1.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)LootVase10Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{LootVase10Block.box((double)13.0, (double)2.0, (double)6.525, (double)16.0, (double)12.0, (double)9.525), LootVase10Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), LootVase10Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), LootVase10Block.box((double)0.0, (double)2.0, (double)6.525, (double)3.0, (double)12.0, (double)9.525)});
            case Direction.NORTH -> Shapes.or((VoxelShape)LootVase10Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{LootVase10Block.box((double)0.0, (double)2.0, (double)6.475, (double)3.0, (double)12.0, (double)9.475), LootVase10Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), LootVase10Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), LootVase10Block.box((double)13.0, (double)2.0, (double)6.475, (double)16.0, (double)12.0, (double)9.475)});
            case Direction.EAST -> Shapes.or((VoxelShape)LootVase10Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{LootVase10Block.box((double)6.525, (double)2.0, (double)0.0, (double)9.525, (double)12.0, (double)3.0), LootVase10Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), LootVase10Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), LootVase10Block.box((double)6.525, (double)2.0, (double)13.0, (double)9.525, (double)12.0, (double)16.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)LootVase10Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{LootVase10Block.box((double)6.475, (double)2.0, (double)13.0, (double)9.475, (double)12.0, (double)16.0), LootVase10Block.box((double)5.0, (double)13.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), LootVase10Block.box((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), LootVase10Block.box((double)6.475, (double)2.0, (double)0.0, (double)9.475, (double)12.0, (double)3.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean onDestroyedByPlayer(BlockState blockstate, Level world, BlockPos pos, Player entity, boolean willHarvest, FluidState fluid) {
        boolean retval = super.onDestroyedByPlayer(blockstate, world, pos, entity, willHarvest, fluid);
        SoulVaseDestroyedProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity);
        return retval;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LootVase10BlockEntity(pos, state);
    }

    public boolean triggerEvent(BlockState state, Level world, BlockPos pos, int eventID, int eventParam) {
        super.triggerEvent(state, world, pos, eventID, eventParam);
        BlockEntity blockEntity = world.getBlockEntity(pos);
        return blockEntity == null ? false : blockEntity.triggerEvent(eventID, eventParam);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof LootVase10BlockEntity) {
                LootVase10BlockEntity be = (LootVase10BlockEntity)blockEntity;
                Containers.dropContents((Level)world, (BlockPos)pos, (Container)be);
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level world, BlockPos pos) {
        BlockEntity tileentity = world.getBlockEntity(pos);
        if (tileentity instanceof LootVase10BlockEntity) {
            LootVase10BlockEntity be = (LootVase10BlockEntity)tileentity;
            return AbstractContainerMenu.getRedstoneSignalFromContainer((Container)be);
        }
        return 0;
    }
}

