/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.pipezretriever.net;

import com.lumengrid.pipezretriever.IRetrieveMode;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.gui.ExtractContainer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ToggleRetrieveModeMessage(int index) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ToggleRetrieveModeMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"pipezretriever", (String)"toggle_retrieve_mode"));
    public static final StreamCodec<FriendlyByteBuf, ToggleRetrieveModeMessage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ToggleRetrieveModeMessage::index, ToggleRetrieveModeMessage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ToggleRetrieveModeMessage message, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            AbstractContainerMenu patt1$temp = player.containerMenu;
            if (!(patt1$temp instanceof ExtractContainer)) {
                return;
            }
            ExtractContainer extractContainer = (ExtractContainer)patt1$temp;
            PipeLogicTileEntity pipe = extractContainer.getPipe();
            if (pipe == null) {
                return;
            }
            if (!(pipe instanceof IRetrieveMode)) {
                return;
            }
            IRetrieveMode retrieveMode = (IRetrieveMode)pipe;
            boolean currentState = retrieveMode.isRetrieving(extractContainer.getSide());
            retrieveMode.setRetrieving(extractContainer.getSide(), !currentState);
            pipe.syncData(player);
        });
    }
}

