/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.pipezretriever.mixin;

import com.lumengrid.pipezretriever.IRetrieveMode;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PipeTileEntity.class})
public abstract class PipeTileEntityMixin
extends BlockEntity
implements IRetrieveMode {
    @Unique
    private boolean[] pipezretriever$retrievingSides = new boolean[Direction.values().length];

    public PipeTileEntityMixin(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public boolean isRetrieving(Direction side) {
        return this.pipezretriever$retrievingSides[side.get3DDataValue()];
    }

    @Override
    public void setRetrieving(Direction side, boolean retrieving) {
        this.pipezretriever$retrievingSides[side.get3DDataValue()] = retrieving;
        this.setChanged();
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")}, remap=true)
    private void pipezretriever$loadAdditional(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        ListTag retrievingList;
        this.pipezretriever$retrievingSides = new boolean[Direction.values().length];
        if (tag.contains("PipezRetriever_RetrievingSides", 9) && (retrievingList = tag.getList("PipezRetriever_RetrievingSides", 1)).size() >= this.pipezretriever$retrievingSides.length) {
            for (int i = 0; i < this.pipezretriever$retrievingSides.length; ++i) {
                this.pipezretriever$retrievingSides[i] = ((ByteTag)retrievingList.get(i)).getAsByte() != 0;
            }
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")}, remap=true)
    private void pipezretriever$saveAdditional(CompoundTag tag, HolderLookup.Provider registries, CallbackInfo ci) {
        ListTag retrievingList = new ListTag();
        for (boolean retrieving : this.pipezretriever$retrievingSides) {
            retrievingList.add((Object)ByteTag.valueOf((boolean)retrieving));
        }
        tag.put("PipezRetriever_RetrievingSides", (Tag)retrievingList);
    }
}

