/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.pipezretriever.mixin;

import com.lumengrid.pipezretriever.IRetrieveMode;
import com.lumengrid.pipezretriever.net.ToggleRetrieveModeMessage;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.gui.ExtractContainer;
import de.maxhenkel.pipez.gui.ExtractScreen;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ExtractScreen.class})
public abstract class ExtractScreenMixin
extends AbstractContainerScreen<ExtractContainer> {
    @Unique
    private Button modeButton;

    protected ExtractScreenMixin() {
        super(null, null, null);
    }

    @Inject(method={"init"}, at={@At(value="TAIL")}, remap=false)
    private void pipezretriever$init(CallbackInfo ci) {
        ExtractContainer container = (ExtractContainer)this.menu;
        PipeLogicTileEntity pipe = container.getPipe();
        this.modeButton = Button.builder((Component)this.getButtonText(pipe, container), button -> PacketDistributor.sendToServer((CustomPacketPayload)new ToggleRetrieveModeMessage(0), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + 32, this.topPos - 22, 60, 20).build();
        this.addRenderableWidget((GuiEventListener)this.modeButton);
        this.pipezretriever$checkRetrieveButton();
    }

    @Inject(method={"containerTick"}, at={@At(value="TAIL")}, remap=false)
    private void pipezretriever$containerTick(CallbackInfo ci) {
        this.pipezretriever$checkRetrieveButton();
    }

    @Unique
    private void pipezretriever$checkRetrieveButton() {
        if (this.modeButton == null) {
            return;
        }
        ExtractContainer container = (ExtractContainer)this.menu;
        PipeLogicTileEntity pipe = container.getPipe();
        this.modeButton.active = true;
        this.modeButton.setMessage(this.getButtonText(pipe, container));
    }

    @Unique
    private Component getButtonText(PipeLogicTileEntity pipe, ExtractContainer container) {
        IRetrieveMode retrieveMode;
        boolean isRetrieving;
        if (pipe instanceof IRetrieveMode && (isRetrieving = (retrieveMode = (IRetrieveMode)pipe).isRetrieving(container.getSide()))) {
            return Component.literal((String)"Retrieve");
        }
        return Component.literal((String)"Extract");
    }
}

