/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.pipezretriever;

import com.lumengrid.pipezretriever.IRetrieveMode;
import de.maxhenkel.pipez.Filter;
import de.maxhenkel.pipez.blocks.tileentity.PipeLogicTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.PipeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.UpgradeTileEntity;
import de.maxhenkel.pipez.blocks.tileentity.types.EnergyPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.FluidPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.GasPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.ItemPipeType;
import de.maxhenkel.pipez.blocks.tileentity.types.PipeType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class RetrieveHelper {
    public static boolean checkRedstone(PipeLogicTileEntity tileEntity, Direction side, PipeType<?, ?> pipeType) {
        UpgradeTileEntity.RedstoneMode redstoneMode = tileEntity.getRedstoneMode(side, pipeType);
        boolean hasPower = tileEntity.isRedstonePowered();
        return switch (redstoneMode) {
            default -> throw new MatchException(null, null);
            case UpgradeTileEntity.RedstoneMode.IGNORED -> true;
            case UpgradeTileEntity.RedstoneMode.OFF_WHEN_POWERED -> {
                if (!hasPower) {
                    yield true;
                }
                yield false;
            }
            case UpgradeTileEntity.RedstoneMode.ON_WHEN_POWERED -> hasPower;
            case UpgradeTileEntity.RedstoneMode.ALWAYS_OFF -> false;
        };
    }

    private static boolean isConnectionInRetrieveMode(Level level, PipeTileEntity.Connection connection) {
        BlockPos pos = connection.getPos();
        Direction side = connection.getDirection();
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof IRetrieveMode) {
            IRetrieveMode retrieveMode = (IRetrieveMode)be;
            if (be instanceof PipeTileEntity) {
                PipeTileEntity pipe = (PipeTileEntity)be;
                return pipe.isExtracting(side) && retrieveMode.isRetrieving(side);
            }
        }
        return false;
    }

    public static void retrieveItems(ItemPipeType pipeType, PipeLogicTileEntity tileEntity, Direction side) {
        PipeTileEntity.Connection extractingConnection = tileEntity.getExtractingConnection(side);
        if (extractingConnection == null) {
            return;
        }
        IItemHandler destination = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, extractingConnection.getPos(), (Object)extractingConnection.getDirection());
        if (destination == null) {
            return;
        }
        List connections = tileEntity.getSortedConnections(side, (PipeType)pipeType);
        int rate = pipeType.getRate(tileEntity.getUpgrade(side));
        List filters = tileEntity.getFilters(side, (PipeType)pipeType);
        UpgradeTileEntity.FilterMode filterMode = tileEntity.getFilterMode(side, (PipeType)pipeType);
        UpgradeTileEntity.Distribution distribution = tileEntity.getDistribution(side, (PipeType)pipeType);
        if (distribution == UpgradeTileEntity.Distribution.ROUND_ROBIN) {
            RetrieveHelper.retrieveItemsRoundRobin(tileEntity, side, pipeType, connections, destination, rate, filters, filterMode);
        } else {
            RetrieveHelper.retrieveItemsOrdered(tileEntity, connections, destination, rate, filters, filterMode);
        }
    }

    private static void retrieveItemsRoundRobin(PipeLogicTileEntity tileEntity, Direction side, ItemPipeType pipeType, List<PipeTileEntity.Connection> connections, IItemHandler destination, int rate, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        if (connections.isEmpty()) {
            return;
        }
        int itemsToTransfer = rate;
        boolean[] sourcesEmpty = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, (PipeType)pipeType) % connections.size();
        while (itemsToTransfer > 0 && RetrieveHelper.hasAvailable(sourcesEmpty)) {
            int moved;
            PipeTileEntity.Connection connection = connections.get(p);
            if (RetrieveHelper.isConnectionInRetrieveMode(tileEntity.getLevel(), connection)) {
                sourcesEmpty[p] = true;
                p = (p + 1) % connections.size();
                continue;
            }
            IItemHandler source = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, connection.getPos(), (Object)connection.getDirection());
            boolean transferred = false;
            if (source != null && !sourcesEmpty[p] && (moved = RetrieveHelper.transferItems(source, destination, 1, filters, filterMode)) > 0) {
                transferred = true;
                itemsToTransfer -= moved;
            }
            if (!transferred) {
                sourcesEmpty[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, (PipeType)pipeType, p);
    }

    private static void retrieveItemsOrdered(PipeLogicTileEntity tileEntity, List<PipeTileEntity.Connection> connections, IItemHandler destination, int rate, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        int itemsToTransfer = rate;
        for (PipeTileEntity.Connection connection : connections) {
            IItemHandler source;
            if (itemsToTransfer <= 0) break;
            if (RetrieveHelper.isConnectionInRetrieveMode(tileEntity.getLevel(), connection) || (source = (IItemHandler)tileEntity.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, connection.getPos(), (Object)connection.getDirection())) == null) continue;
            int moved = RetrieveHelper.transferItems(source, destination, itemsToTransfer, filters, filterMode);
            itemsToTransfer -= moved;
        }
    }

    private static int transferItems(IItemHandler source, IItemHandler destination, int maxAmount, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        int transferred = 0;
        for (int slot = 0; slot < source.getSlots() && transferred < maxAmount; ++slot) {
            ItemStack stack = source.extractItem(slot, maxAmount - transferred, true);
            if (stack.isEmpty() || !RetrieveHelper.canTransferItem(stack, filters, filterMode)) continue;
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)destination, (ItemStack)stack, (boolean)true);
            int toTransfer = stack.getCount() - remainder.getCount();
            if (toTransfer <= 0) continue;
            ItemStack extracted = source.extractItem(slot, toTransfer, false);
            ItemHandlerHelper.insertItemStacked((IItemHandler)destination, (ItemStack)extracted, (boolean)false);
            transferred += toTransfer;
        }
        return transferred;
    }

    private static boolean canTransferItem(ItemStack stack, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        if (filters.isEmpty()) {
            return filterMode == UpgradeTileEntity.FilterMode.WHITELIST;
        }
        boolean matchesAnyFilter = false;
        for (Filter<?, ?> filter : filters) {
            Filter<?, ?> itemFilter = filter;
            if (itemFilter.getTag() == null || !itemFilter.getTag().contains((Object)stack.getItem())) continue;
            if (itemFilter.isInvert()) {
                return filterMode == UpgradeTileEntity.FilterMode.BLACKLIST;
            }
            matchesAnyFilter = true;
        }
        return filterMode == UpgradeTileEntity.FilterMode.WHITELIST ? matchesAnyFilter : !matchesAnyFilter;
    }

    public static void retrieveFluids(FluidPipeType pipeType, PipeLogicTileEntity tileEntity, Direction side) {
        PipeTileEntity.Connection extractingConnection = tileEntity.getExtractingConnection(side);
        if (extractingConnection == null) {
            return;
        }
        IFluidHandler destination = (IFluidHandler)tileEntity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, extractingConnection.getPos(), (Object)extractingConnection.getDirection());
        if (destination == null) {
            return;
        }
        List connections = tileEntity.getSortedConnections(side, (PipeType)pipeType);
        int rate = pipeType.getRate(tileEntity.getUpgrade(side));
        List filters = tileEntity.getFilters(side, (PipeType)pipeType);
        UpgradeTileEntity.FilterMode filterMode = tileEntity.getFilterMode(side, (PipeType)pipeType);
        int mbToTransfer = rate;
        for (PipeTileEntity.Connection connection : connections) {
            int filled;
            FluidStack drained;
            IFluidHandler source;
            if (mbToTransfer <= 0) break;
            if (RetrieveHelper.isConnectionInRetrieveMode(tileEntity.getLevel(), connection) || (source = (IFluidHandler)tileEntity.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, connection.getPos(), (Object)connection.getDirection())) == null || (drained = source.drain(mbToTransfer, IFluidHandler.FluidAction.SIMULATE)).isEmpty() || !RetrieveHelper.canTransferFluid(drained, filters, filterMode) || (filled = destination.fill(drained, IFluidHandler.FluidAction.SIMULATE)) <= 0) continue;
            FluidStack toDrain = source.drain(filled, IFluidHandler.FluidAction.EXECUTE);
            destination.fill(toDrain, IFluidHandler.FluidAction.EXECUTE);
            mbToTransfer -= filled;
        }
    }

    private static boolean canTransferFluid(FluidStack stack, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        if (filters.isEmpty()) {
            return filterMode == UpgradeTileEntity.FilterMode.WHITELIST;
        }
        boolean matchesAnyFilter = false;
        for (Filter<?, ?> filter : filters) {
            Filter<?, ?> fluidFilter = filter;
            if (fluidFilter.getTag() == null || !fluidFilter.getTag().contains((Object)stack.getFluid())) continue;
            if (fluidFilter.isInvert()) {
                return filterMode == UpgradeTileEntity.FilterMode.BLACKLIST;
            }
            matchesAnyFilter = true;
        }
        return filterMode == UpgradeTileEntity.FilterMode.WHITELIST ? matchesAnyFilter : !matchesAnyFilter;
    }

    public static void retrieveEnergy(EnergyPipeType pipeType, PipeLogicTileEntity tileEntity, Direction side) {
        PipeTileEntity.Connection extractingConnection = tileEntity.getExtractingConnection(side);
        if (extractingConnection == null) {
            return;
        }
        IEnergyStorage destination = extractingConnection.getEnergyHandler();
        if (destination == null) {
            return;
        }
        int testReceive = destination.receiveEnergy(1, true);
        if (!destination.canReceive() && testReceive <= 0) {
            return;
        }
        List connections = tileEntity.getSortedConnections(side, (PipeType)pipeType);
        if (connections.isEmpty()) {
            return;
        }
        int rate = pipeType.getRate(tileEntity.getUpgrade(side));
        UpgradeTileEntity.Distribution distribution = tileEntity.getDistribution(side, (PipeType)pipeType);
        if (distribution == UpgradeTileEntity.Distribution.ROUND_ROBIN) {
            RetrieveHelper.retrieveEnergyRoundRobin(tileEntity, side, pipeType, connections, destination, rate);
        } else {
            RetrieveHelper.retrieveEnergyOrdered(tileEntity, connections, destination, rate);
        }
    }

    private static void retrieveEnergyRoundRobin(PipeLogicTileEntity tileEntity, Direction side, EnergyPipeType pipeType, List<PipeTileEntity.Connection> connections, IEnergyStorage destination, int rate) {
        if (connections.isEmpty()) {
            return;
        }
        int energyToTransfer = rate;
        int p = tileEntity.getRoundRobinIndex(side, (PipeType)pipeType) % connections.size();
        ArrayList<IEnergyStorage> sources = new ArrayList<IEnergyStorage>();
        for (int i = 0; i < connections.size(); ++i) {
            IEnergyStorage source;
            int index = (i + p) % connections.size();
            PipeTileEntity.Connection connection = connections.get(index);
            if (RetrieveHelper.isConnectionInRetrieveMode(tileEntity.getLevel(), connection) || (source = connection.getEnergyHandler()) == null || source.getEnergyStored() <= 0 || !source.canExtract() && source.extractEnergy(1, true) <= 0) continue;
            sources.add(source);
        }
        for (IEnergyStorage source : sources) {
            if (energyToTransfer <= 0) break;
            int perSource = Math.max(1, energyToTransfer / sources.size());
            int simulatedExtract = source.extractEnergy(Math.min(perSource, energyToTransfer), true);
            if (simulatedExtract > 0) {
                int transferred = RetrieveHelper.pushEnergy(source, destination, simulatedExtract);
                energyToTransfer -= transferred;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, (PipeType)pipeType, p);
    }

    private static void retrieveEnergyOrdered(PipeLogicTileEntity tileEntity, List<PipeTileEntity.Connection> connections, IEnergyStorage destination, int rate) {
        int energyToTransfer = rate;
        for (PipeTileEntity.Connection connection : connections) {
            int simulatedExtract;
            IEnergyStorage source;
            if (energyToTransfer <= 0) break;
            if (RetrieveHelper.isConnectionInRetrieveMode(tileEntity.getLevel(), connection) || (source = connection.getEnergyHandler()) == null || source.getEnergyStored() <= 0) continue;
            int testExtract = source.extractEnergy(1, true);
            if (!source.canExtract() && testExtract <= 0 || (simulatedExtract = source.extractEnergy(energyToTransfer, true)) <= 0) continue;
            int transferred = RetrieveHelper.pushEnergy(source, destination, simulatedExtract);
            energyToTransfer -= transferred;
        }
    }

    private static int pushEnergy(IEnergyStorage source, IEnergyStorage destination, int maxAmount) {
        int canReceive = destination.receiveEnergy(maxAmount, true);
        if (canReceive <= 0) {
            return 0;
        }
        int extracted = source.extractEnergy(canReceive, false);
        if (extracted <= 0) {
            return 0;
        }
        int received = destination.receiveEnergy(extracted, false);
        return received;
    }

    public static void retrieveGas(GasPipeType pipeType, PipeLogicTileEntity tileEntity, Direction side) {
        PipeTileEntity.Connection extractingConnection = tileEntity.getExtractingConnection(side);
        if (extractingConnection == null) {
            return;
        }
        IChemicalHandler destination = extractingConnection.getChemicalHandler();
        if (destination == null) {
            return;
        }
        List connections = tileEntity.getSortedConnections(side, (PipeType)pipeType);
        long rate = pipeType.getRate(tileEntity.getUpgrade(side));
        List filters = tileEntity.getFilters(side, (PipeType)pipeType);
        UpgradeTileEntity.FilterMode filterMode = tileEntity.getFilterMode(side, (PipeType)pipeType);
        UpgradeTileEntity.Distribution distribution = tileEntity.getDistribution(side, (PipeType)pipeType);
        if (distribution == UpgradeTileEntity.Distribution.ROUND_ROBIN) {
            RetrieveHelper.retrieveGasRoundRobin(tileEntity, side, pipeType, connections, destination, rate, filters, filterMode);
        } else {
            RetrieveHelper.retrieveGasOrdered(tileEntity, connections, destination, rate, filters, filterMode);
        }
    }

    private static void retrieveGasRoundRobin(PipeLogicTileEntity tileEntity, Direction side, GasPipeType pipeType, List<PipeTileEntity.Connection> connections, IChemicalHandler destination, long rate, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        if (connections.isEmpty()) {
            return;
        }
        long mbToTransfer = rate;
        boolean[] sourcesEmpty = new boolean[connections.size()];
        int p = tileEntity.getRoundRobinIndex(side, (PipeType)pipeType) % connections.size();
        while (mbToTransfer > 0L && RetrieveHelper.hasAvailable(sourcesEmpty)) {
            long moved;
            PipeTileEntity.Connection connection = connections.get(p);
            if (RetrieveHelper.isConnectionInRetrieveMode(tileEntity.getLevel(), connection)) {
                sourcesEmpty[p] = true;
                p = (p + 1) % connections.size();
                continue;
            }
            IChemicalHandler source = connection.getChemicalHandler();
            boolean transferred = false;
            if (source != null && !sourcesEmpty[p] && (moved = RetrieveHelper.transferGas(source, destination, mbToTransfer, filters, filterMode)) > 0L) {
                transferred = true;
                mbToTransfer -= moved;
            }
            if (!transferred) {
                sourcesEmpty[p] = true;
            }
            p = (p + 1) % connections.size();
        }
        tileEntity.setRoundRobinIndex(side, (PipeType)pipeType, p);
    }

    private static void retrieveGasOrdered(PipeLogicTileEntity tileEntity, List<PipeTileEntity.Connection> connections, IChemicalHandler destination, long rate, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        long mbToTransfer = rate;
        for (PipeTileEntity.Connection connection : connections) {
            IChemicalHandler source;
            if (mbToTransfer <= 0L) break;
            if (RetrieveHelper.isConnectionInRetrieveMode(tileEntity.getLevel(), connection) || (source = connection.getChemicalHandler()) == null) continue;
            long moved = RetrieveHelper.transferGas(source, destination, mbToTransfer, filters, filterMode);
            mbToTransfer -= moved;
        }
    }

    private static long transferGas(IChemicalHandler source, IChemicalHandler destination, long maxAmount, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        long transferred = 0L;
        for (int tank = 0; tank < source.getChemicalTanks() && transferred < maxAmount; ++tank) {
            ChemicalStack toExtract;
            ChemicalStack simulatedExtract;
            ChemicalStack gasInTank = source.getChemicalInTank(tank);
            if (gasInTank.isEmpty() || !RetrieveHelper.canTransferGas(gasInTank, filters, filterMode) || (simulatedExtract = source.extractChemical(toExtract = new ChemicalStack(gasInTank.getChemical(), maxAmount - transferred), Action.SIMULATE)).isEmpty()) continue;
            ChemicalStack remainder = destination.insertChemical(simulatedExtract, Action.SIMULATE);
            long toTransfer = simulatedExtract.getAmount() - remainder.getAmount();
            if (toTransfer <= 0L) continue;
            ChemicalStack extracted = source.extractChemical(new ChemicalStack(gasInTank.getChemical(), toTransfer), Action.EXECUTE);
            destination.insertChemical(extracted, Action.EXECUTE);
            transferred += toTransfer;
        }
        return transferred;
    }

    private static boolean canTransferGas(ChemicalStack stack, List<Filter<?, ?>> filters, UpgradeTileEntity.FilterMode filterMode) {
        if (filters.isEmpty()) {
            return true;
        }
        for (Filter<?, ?> filter : filters) {
            Filter<?, ?> gasFilter = filter;
            if (!gasFilter.isInvert() || !RetrieveHelper.matchesGasFilter(gasFilter, stack)) continue;
            return false;
        }
        List nonInvertedFilters = filters.stream().map(f -> f).filter(f -> !f.isInvert()).collect(Collectors.toList());
        if (nonInvertedFilters.isEmpty()) {
            return true;
        }
        boolean matchesAny = nonInvertedFilters.stream().anyMatch(f -> RetrieveHelper.matchesGasFilter(f, stack));
        return filterMode == UpgradeTileEntity.FilterMode.WHITELIST ? matchesAny : !matchesAny;
    }

    private static boolean matchesGasFilter(Filter<?, Chemical> filter, ChemicalStack stack) {
        return filter.getTag() == null || filter.getTag().contains((Object)stack.getChemical());
    }

    private static boolean hasAvailable(boolean[] array) {
        for (boolean b : array) {
            if (b) continue;
            return true;
        }
        return false;
    }
}

