/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector.transformer.patch;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.PatchInstance;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.MethodTransform;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchContext;
import org.slf4j.Logger;

public record RedirectAccessorToMethod(String value) implements MethodTransform
{
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    public Collection<String> getAcceptedAnnotations() {
        return Set.of("Lorg/spongepowered/asm/mixin/gen/Accessor;");
    }

    @Override
    public Patch.Result apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchContext context) {
        AnnotationVisitor visitor = methodNode.visitAnnotation("Lorg/spongepowered/asm/mixin/gen/Invoker;", true);
        visitor.visit("value", (Object)this.value);
        visitor.visitEnd();
        methodNode.visibleAnnotations.remove(methodContext.methodAnnotation().unwrap());
        LOGGER.info(PatchInstance.MIXINPATCH, "Redirecting accessor {}.{} to invoke method {}", new Object[]{classNode.name, methodNode.name, this.value});
        return Patch.Result.APPLY;
    }
}

