/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.analysis.locals;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.util.AdapterUtil;
import org.sinytra.adapter.patch.util.SingleValueHandle;

public class LVTSnapshot {
    private final List<LocalVar> locals;
    private final int[] vars;

    public LVTSnapshot(List<LocalVar> locals, int[] vars) {
        this.locals = locals;
        this.vars = vars;
    }

    public void applyDifference(MethodNode newNode) {
        LVTSnapshot newLVT = LVTSnapshot.take(newNode);
        ArrayList<LocalVar> removed = new ArrayList<LocalVar>(this.locals);
        removed.removeIf(newLVT.locals::contains);
        int[] newVars = Arrays.copyOf(this.vars, this.vars.length);
        for (LocalVar localVar : removed) {
            for (int i = 0; i < newVars.length; ++i) {
                if (newVars[i] <= localVar.index) continue;
                int n = i;
                newVars[n] = newVars[n] - localVar.desc.getSize();
            }
            newNode.localVariables.forEach(node -> {
                if (node.index > local.index) {
                    node.index -= local.desc.getSize();
                }
            });
        }
        ArrayList<LocalVar> added = new ArrayList<LocalVar>(newLVT.locals);
        added.removeIf(this.locals::contains);
        for (LocalVar local : added) {
            for (int i = 0; i < newVars.length; ++i) {
                if (newVars[i] < local.index) continue;
                int n = i;
                newVars[n] = newVars[n] + local.desc.getSize();
            }
            newNode.localVariables.forEach(node -> {
                if (!node.name.equals(local.name) && node.index >= local.index) {
                    node.index += local.desc.getSize();
                }
            });
        }
        Int2IntArrayMap int2IntArrayMap = new Int2IntArrayMap();
        for (int i = 0; i < this.vars.length; ++i) {
            int2IntArrayMap.put(this.vars[i], newVars[i]);
        }
        newNode.instructions.forEach(arg_0 -> LVTSnapshot.lambda$applyDifference$2((Int2IntMap)int2IntArrayMap, arg_0));
    }

    public static LVTSnapshot take(MethodNode node) {
        ArrayList<LocalVar> locals = new ArrayList<LocalVar>();
        IntArraySet vars = new IntArraySet();
        node.localVariables.forEach(local -> locals.add(new LocalVar(local.name, Type.getType((String)local.desc), local.index)));
        node.instructions.forEach(arg_0 -> LVTSnapshot.lambda$take$4((IntSet)vars, arg_0));
        int[] varsArray = vars.toIntArray();
        Arrays.sort(varsArray);
        Collections.sort(locals);
        return new LVTSnapshot(locals, varsArray);
    }

    public static void with(MethodNode methodNode, Runnable action) {
        LVTSnapshot snapshot = LVTSnapshot.take(methodNode);
        action.run();
        snapshot.applyDifference(methodNode);
    }

    private static /* synthetic */ void lambda$take$4(IntSet vars, AbstractInsnNode insn) {
        SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
        if (handle != null) {
            vars.add(handle.get().intValue());
        }
    }

    private static /* synthetic */ void lambda$applyDifference$2(Int2IntMap old2New, AbstractInsnNode insn) {
        SingleValueHandle<Integer> handle = AdapterUtil.handleLocalVarInsnValue(insn);
        if (handle != null) {
            int idx = handle.get();
            handle.set(old2New.getOrDefault(idx, idx));
        }
    }

    public record LocalVar(String name, Type desc, int index) implements Comparable<LocalVar>
    {
        @Override
        public int compareTo(@NotNull LocalVar o) {
            return Comparator.naturalOrder().compare(this.index, o.index);
        }
    }
}

