/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.goal.mauler;

import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public final class MaulerBurrowDownGoal
extends Goal {
    private final MaulerEntity mauler;
    private int burrowedDownTicks;
    private Block blockUnderMauler;
    private SoundEvent soundForBlockUnderMauler;
    private boolean isRunning;

    public MaulerBurrowDownGoal(MaulerEntity mauler) {
        this.mauler = mauler;
    }

    public boolean canUse() {
        if (this.mauler.isAngry() || this.mauler.level().isNight() || this.mauler.getNavigation().isInProgress() || this.mauler.getRandom().nextFloat() < 0.999f || this.mauler.getTicksUntilNextBurrowingDown() > 0) {
            return false;
        }
        this.setBlockUnderMauler();
        boolean isRelatedBlock = this.blockUnderMauler == Blocks.SAND || this.blockUnderMauler == Blocks.RED_SAND || this.blockUnderMauler == Blocks.DIRT || this.blockUnderMauler == Blocks.COARSE_DIRT || this.blockUnderMauler == Blocks.GRASS_BLOCK;
        return isRelatedBlock;
    }

    public boolean canContinueToUse() {
        return this.burrowedDownTicks > 0;
    }

    public void start() {
        this.isRunning = true;
        this.mauler.getNavigation().setSpeedModifier(0.0);
        this.mauler.getNavigation().stop();
        if (this.getBurrowedDownTicks() == 0) {
            this.burrowedDownTicks = this.mauler.getRandom().nextIntBetweenInclusive(600, 1200);
        }
        this.mauler.setBurrowedDown(true);
        this.mauler.setInvulnerable(true);
        this.soundForBlockUnderMauler = this.blockUnderMauler == Blocks.SAND || this.blockUnderMauler == Blocks.RED_SAND ? SoundEvents.SAND_BREAK : SoundEvents.GRASS_BREAK;
    }

    public void stop() {
        this.isRunning = false;
        this.mauler.setInvisible(false);
        this.mauler.setInvulnerable(false);
        this.mauler.setBurrowedDown(false);
        this.mauler.setTicksUntilNextBurrowingDown(this.mauler.getRandom().nextIntBetweenInclusive(3000, 6000));
    }

    public void tick() {
        float burrowingDownAnimationProgress = this.mauler.getBurrowingDownAnimationProgress();
        if (burrowingDownAnimationProgress > 0.0f && burrowingDownAnimationProgress < 1.0f) {
            Level world;
            BlockPos blockPos = this.mauler.blockPosition();
            if (this.mauler.tickCount % 3 == 0) {
                this.mauler.level().playSound(null, blockPos, this.soundForBlockUnderMauler, SoundSource.BLOCKS, 0.3f, 1.0f);
            }
            if ((world = this.mauler.level()).isClientSide()) {
                return;
            }
            for (int i = 0; i < 7; ++i) {
                ((ServerLevel)world).sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, this.blockUnderMauler.defaultBlockState()), this.mauler.getRandomX(0.5), this.mauler.getRandomY(), this.mauler.getRandomZ(0.5), 1, this.mauler.getRandom().nextGaussian() * 0.02, this.mauler.getRandom().nextGaussian() * 0.02, this.mauler.getRandom().nextGaussian() * 0.02, 0.1);
            }
        } else if (this.mauler.isBurrowedDown() && this.mauler.getBurrowingDownAnimationProgress() == 1.0f) {
            this.mauler.setInvisible(true);
        }
        --this.burrowedDownTicks;
    }

    public void setBlockUnderMauler() {
        BlockPos blockPos = this.mauler.blockPosition().below();
        BlockState blockState = this.mauler.level().getBlockState(blockPos);
        this.blockUnderMauler = blockState.getBlock();
    }

    public int getBurrowedDownTicks() {
        return this.burrowedDownTicks;
    }

    public void setBurrowedDownTicks(int burrowedDownTicks) {
        this.burrowedDownTicks = burrowedDownTicks;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

