/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.model.animation.KeyframeModelAnimator;
import com.faboslav.friendsandfoes.common.client.render.entity.model.animation.ModelPartModelAnimator;
import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import java.util.ArrayList;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class CrabEntityModel<T extends CrabEntity>
extends HierarchicalModel<T> {
    private static final String MAIN = "main";
    private static final String BODY = "body";
    private static final String LEFT_FEELER = "leftFeeler";
    private static final String RIGHT_FEELER = "rightFeeler";
    private static final String LEFT_CLAW = "leftClaw";
    private static final String LEFT_CLAW_PARTS = "leftClawParts";
    private static final String RIGHT_CLAW = "rightClaw";
    private static final String LEFT_FRONT_LEG_JOINT = "leftFrontLegJoint";
    private static final String LEFT_FRONT_LEG = "leftFrontLeg";
    private static final String LEFT_MIDDLE_LEG_JOINT = "leftMiddleLegJoint";
    private static final String LEFT_MIDDLE_LEG = "leftMiddleLeg";
    private static final String LEFT_BACK_LEG_JOINT = "leftBackLegJoint";
    private static final String LEFT_BACK_LEG = "leftBackLeg";
    private static final String RIGHT_FRONT_LEG_JOINT = "rightFrontLegJoint";
    private static final String RIGHT_FRONT_LEG = "rightFrontLeg";
    private static final String RIGHT_MIDDLE_LEG_JOINT = "rightMiddleLegJoint";
    private static final String RIGHT_MIDDLE_LEG = "rightMiddleLeg";
    private static final String RIGHT_BACK_LEG_JOINT = "rightBackLegJoint";
    private static final String RIGHT_BACK_LEG = "rightBackLeg";
    private final ModelPart root;
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart leftFeeler;
    private final ModelPart rightFeeler;
    private final ModelPart leftClaw;
    private final ModelPart leftClawParts;
    private final ModelPart rightClaw;
    private final ModelPart leftFrontLegJoint;
    private final ModelPart leftFrontLeg;
    private final ModelPart leftMiddleLegJoint;
    private final ModelPart leftMiddleLeg;
    private final ModelPart leftBackLegJoint;
    private final ModelPart leftBackLeg;
    private final ModelPart rightFrontLegJoint;
    private final ModelPart rightFrontLeg;
    private final ModelPart rightMiddleLegJoint;
    private final ModelPart rightMiddleLeg;
    private final ModelPart rightBackLegJoint;
    private final ModelPart rightBackLeg;

    public CrabEntityModel(ModelPart root) {
        this.root = root;
        this.main = this.root.getChild(MAIN);
        this.body = this.main.getChild(BODY);
        this.leftFeeler = this.body.getChild(LEFT_FEELER);
        this.rightFeeler = this.body.getChild(RIGHT_FEELER);
        this.leftClaw = this.body.getChild(LEFT_CLAW);
        this.leftClawParts = this.leftClaw.getChild(LEFT_CLAW_PARTS);
        this.rightClaw = this.body.getChild(RIGHT_CLAW);
        this.leftFrontLegJoint = this.main.getChild(LEFT_FRONT_LEG_JOINT);
        this.leftFrontLeg = this.leftFrontLegJoint.getChild(LEFT_FRONT_LEG);
        this.leftMiddleLegJoint = this.main.getChild(LEFT_MIDDLE_LEG_JOINT);
        this.leftMiddleLeg = this.leftMiddleLegJoint.getChild(LEFT_MIDDLE_LEG);
        this.leftBackLegJoint = this.main.getChild(LEFT_BACK_LEG_JOINT);
        this.leftBackLeg = this.leftBackLegJoint.getChild(LEFT_BACK_LEG);
        this.rightFrontLegJoint = this.main.getChild(RIGHT_FRONT_LEG_JOINT);
        this.rightFrontLeg = this.rightFrontLegJoint.getChild(RIGHT_FRONT_LEG);
        this.rightMiddleLegJoint = this.main.getChild(RIGHT_MIDDLE_LEG_JOINT);
        this.rightMiddleLeg = this.rightMiddleLegJoint.getChild(RIGHT_MIDDLE_LEG);
        this.rightBackLegJoint = this.main.getChild(RIGHT_BACK_LEG_JOINT);
        this.rightBackLeg = this.rightBackLegJoint.getChild(RIGHT_BACK_LEG);
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.getRoot();
        PartDefinition main = root.addOrReplaceChild(MAIN, CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)24.0f, (float)0.0f, (float)-1.5708f, (float)-1.5708f, (float)1.5708f));
        PartDefinition body = main.addOrReplaceChild(BODY, CubeListBuilder.create().texOffs(0, 0).addBox(-7.0f, -6.0f, -5.0f, 14.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(38, 0).addBox(-6.0f, -7.0f, -5.0f, 12.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)0.0f));
        PartDefinition leftFeeler = body.addOrReplaceChild(LEFT_FEELER, CubeListBuilder.create().texOffs(38, 1).mirror().addBox(-1.0f, 0.0f, -1.05f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.0f, (float)-6.0f, (float)-4.25f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition rightFeeler = body.addOrReplaceChild(RIGHT_FEELER, CubeListBuilder.create().texOffs(38, 1).addBox(-1.0f, 0.0f, -1.05f, 2.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)-6.0f, (float)-4.25f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition leftClaw = body.addOrReplaceChild(LEFT_CLAW, CubeListBuilder.create(), PartPose.offsetAndRotation((float)7.0f, (float)-3.0f, (float)-5.0f, (float)0.0f, (float)-1.0472f, (float)-0.1309f));
        PartDefinition leftClawParts = leftClaw.addOrReplaceChild(LEFT_CLAW_PARTS, CubeListBuilder.create().texOffs(0, 16).addBox(-11.75f, -3.5f, -2.5f, 12.0f, 7.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(0, 28).addBox(-10.75f, 0.5f, -1.5f, 10.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)1.0f, (float)-2.5f));
        PartDefinition rightClaw = body.addOrReplaceChild(RIGHT_CLAW, CubeListBuilder.create().texOffs(44, 16).mirror().addBox(-2.0f, -1.5f, -4.0f, 6.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-7.0f, (float)-2.0f, (float)-5.0f, (float)0.0f, (float)0.829f, (float)0.2182f));
        PartDefinition leftFrontLegJoint = main.addOrReplaceChild(LEFT_FRONT_LEG_JOINT, CubeListBuilder.create(), PartPose.offsetAndRotation((float)7.0f, (float)-3.5f, (float)-1.0f, (float)0.0f, (float)0.6109f, (float)0.0f));
        PartDefinition leftFrontLeg = leftFrontLegJoint.addOrReplaceChild(LEFT_FRONT_LEG, CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.829f));
        PartDefinition leftMiddleLegJoint = main.addOrReplaceChild(LEFT_MIDDLE_LEG_JOINT, CubeListBuilder.create(), PartPose.offsetAndRotation((float)7.0f, (float)-3.5f, (float)1.0f, (float)0.0f, (float)0.3054f, (float)0.0f));
        PartDefinition leftMiddleLeg = leftMiddleLegJoint.addOrReplaceChild(LEFT_MIDDLE_LEG, CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition leftBackLegJoint = main.addOrReplaceChild(LEFT_BACK_LEG_JOINT, CubeListBuilder.create(), PartPose.offset((float)7.0f, (float)-3.5f, (float)3.0f));
        PartDefinition leftBackLeg = leftBackLegJoint.addOrReplaceChild(LEFT_BACK_LEG, CubeListBuilder.create().texOffs(0, 0).mirror().addBox(0.0f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f));
        PartDefinition rightFrontLegJoint = main.addOrReplaceChild(RIGHT_FRONT_LEG_JOINT, CubeListBuilder.create(), PartPose.offsetAndRotation((float)-7.0f, (float)-3.5f, (float)-1.0f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        PartDefinition rightFrontLeg = rightFrontLegJoint.addOrReplaceChild(RIGHT_FRONT_LEG, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.829f));
        PartDefinition rightMiddleLegJoint = main.addOrReplaceChild(RIGHT_MIDDLE_LEG_JOINT, CubeListBuilder.create(), PartPose.offsetAndRotation((float)-7.0f, (float)-3.5f, (float)1.0f, (float)0.0f, (float)-0.3054f, (float)0.0f));
        PartDefinition rightMiddleLeg = rightMiddleLegJoint.addOrReplaceChild(RIGHT_MIDDLE_LEG, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        PartDefinition rightBackLegJoint = main.addOrReplaceChild(RIGHT_BACK_LEG_JOINT, CubeListBuilder.create(), PartPose.offset((float)-7.0f, (float)-3.5f, (float)3.0f));
        PartDefinition rightBackLeg = rightBackLegJoint.addOrReplaceChild(RIGHT_BACK_LEG, CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(T crab, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.updateKeyframeAnimations((CrabEntity)crab, limbAngle, limbDistance, animationProgress);
        this.updateModelPartAnimations((CrabEntity)crab);
    }

    public void updateKeyframeAnimations(CrabEntity crab, float limbAngle, float limbDistance, float animationProgress) {
        AnimationHolder movementAnimation = crab.getMovementAnimation();
        ArrayList<AnimationHolder> animations = crab.getTrackedAnimations();
        AnimationContextTracker animationContextTracker = crab.getAnimationContextTracker();
        int currentTick = crab.tickCount;
        float animationSpeedModifier = 1.0f;
        KeyframeModelAnimator.updateMovementKeyframeAnimations(this, movementAnimation, limbAngle, limbDistance, 2.5f, 4.5f, animationSpeedModifier);
        KeyframeModelAnimator.updateKeyframeAnimations(this, animationContextTracker, animations, currentTick, animationProgress, animationSpeedModifier);
    }

    public void updateModelPartAnimations(CrabEntity crab) {
        float scaleModifier = crab.getSize().getScaleModifier();
        float pivotX = 0.0f;
        float pivotY = crab.onClimbable() ? 17.0f * scaleModifier : 24.0f;
        float pivotZ = crab.onClimbable() ? -9.0f * scaleModifier : 0.0f;
        float pitch = -1.5708f;
        float yaw = crab.onClimbable() ? 0.0f : -1.5708f;
        float roll = 1.5708f;
        ModelPartModelAnimator.animateModelPartPositionBasedOnTicks(crab.getAnimationContextTracker(), this.main, crab.tickCount, pivotX, pivotY, pivotZ, 20);
        ModelPartModelAnimator.animateModelPartRotationBasedOnTicks(crab.getAnimationContextTracker(), this.main, crab.tickCount, pitch, yaw, roll, 20);
    }
}

