/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.block;

import com.faboslav.friendsandfoes.common.block.FriendsAndFoesOxidizable;
import com.faboslav.friendsandfoes.common.util.WaxableBlocksMap;
import com.faboslav.friendsandfoes.common.versions.VersionedEntity;
import com.faboslav.friendsandfoes.common.versions.VersionedInteractionResult;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;

public final class OnUseOxidizable {
    public static InteractionResult onOxidizableUse(BlockState blockState, Level world, BlockPos blockPos, Player player, BlockHitResult hit) {
        for (InteractionHand hand : InteractionHand.values()) {
            InteractionResult actionResult;
            ItemStack itemStack = player.getItemInHand(hand);
            if (!(itemStack.getItem() instanceof HoneycombItem) && !(itemStack.getItem() instanceof AxeItem) || !(actionResult = OnUseOxidizable.onOxidizableUseHand(blockState, world, blockPos, player, hand, hit)).consumesAction()) continue;
            player.swing(hand);
            return actionResult;
        }
        return InteractionResult.PASS;
    }

    public static InteractionResult onOxidizableUseHand(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult itemInHandUsageResult;
        ItemStack itemStack = player.getItemInHand(hand);
        Item itemInHand = itemStack.getItem();
        UseOnContext itemUsageContext = new UseOnContext(player, hand, hit);
        if (itemInHand instanceof HoneycombItem) {
            Optional<BlockState> possibleWaxedState = OnUseOxidizable.getWaxedState(blockState);
            if (possibleWaxedState.isPresent()) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockPos, itemStack);
                }
                if (!player.isCreative()) {
                    itemStack.shrink(1);
                }
                world.setBlock(blockPos, possibleWaxedState.get(), 11);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)possibleWaxedState.get()));
                world.levelEvent(player, 3003, blockPos, 0);
                return VersionedInteractionResult.success((Entity)player);
            }
        } else if (itemInHand instanceof AxeItem) {
            Optional<BlockState> possibleUnWaxedState = OnUseOxidizable.getUnWaxedState(blockState);
            Optional<BlockState> possibleOxidationState = FriendsAndFoesOxidizable.getPrevious(blockState);
            Optional<Object> possibleState = Optional.empty();
            if (possibleUnWaxedState.isPresent()) {
                world.playSound(player, blockPos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.levelEvent(player, 3004, blockPos, 0);
                possibleState = possibleUnWaxedState;
            } else if (possibleOxidationState.isPresent()) {
                world.playSound(player, blockPos, SoundEvents.AXE_SCRAPE, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.levelEvent(player, 3005, blockPos, 0);
                possibleState = possibleOxidationState;
            }
            if (possibleState.isPresent()) {
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)player, blockPos, itemStack);
                }
                world.setBlock(blockPos, (BlockState)possibleState.get(), 11);
                world.gameEvent((Holder)GameEvent.BLOCK_CHANGE, blockPos, GameEvent.Context.of((Entity)player, (BlockState)((BlockState)possibleState.get())));
                if (player != null) {
                    itemStack.hurtAndBreak(1, (LivingEntity)player, VersionedEntity.getEquipmentSlotForItem(hand));
                }
                return VersionedInteractionResult.success((Entity)player);
            }
            return InteractionResult.PASS;
        }
        if ((itemInHand instanceof HoneycombItem || itemInHand instanceof AxeItem) && (itemInHandUsageResult = itemInHand.useOn(itemUsageContext)).consumesAction()) {
            return itemInHandUsageResult;
        }
        return InteractionResult.PASS;
    }

    private static Optional<BlockState> getWaxedState(BlockState state) {
        return Optional.ofNullable((Block)WaxableBlocksMap.UNWAXED_TO_WAXED_BLOCKS.get().get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
    }

    private static Optional<BlockState> getUnWaxedState(BlockState state) {
        return Optional.ofNullable((Block)WaxableBlocksMap.WAXED_TO_UNWAXED_BLOCKS.get().get((Object)state.getBlock())).map(block -> block.withPropertiesOf(state));
    }
}

