/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.neoforge.client.integration;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.satisfy.beachparty.client.model.RubberRingColoredModel;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.joml.Quaternionf;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class CuriosRubberRingRenderer
implements ICurioRenderer {
    private final RubberRingColoredModel<LivingEntity> model = new RubberRingColoredModel(Minecraft.getInstance().getEntityModels().bakeLayer(RubberRingColoredModel.LAYER_LOCATION));

    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!slotContext.identifier().equals("belt")) {
            return;
        }
        if (stack.isEmpty() || !this.isRubberRing(stack)) {
            return;
        }
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity == null) {
            return;
        }
        ResourceLocation texture = this.getRingTexture(stack);
        this.model.setupAnim(livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        matrixStack.pushPose();
        if (livingEntity.isCrouching()) {
            matrixStack.translate(0.1f, -0.7f, -1.0f);
            matrixStack.mulPose(new Quaternionf().rotationX((float)Math.toRadians(20.0)));
        } else {
            matrixStack.translate(0.1f, -1.4f, -0.5f);
        }
        this.model.renderToBuffer(matrixStack, renderTypeBuffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)texture)), light, OverlayTexture.NO_OVERLAY);
        matrixStack.popPose();
    }

    private boolean isRubberRing(ItemStack stack) {
        return stack.is((Item)ObjectRegistry.RUBBER_RING_BLUE.get()) || stack.is((Item)ObjectRegistry.RUBBER_RING_PINK.get()) || stack.is((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get());
    }

    private ResourceLocation getRingTexture(ItemStack stack) {
        if (stack.is((Item)ObjectRegistry.RUBBER_RING_PINK.get())) {
            return BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_pink.png");
        }
        if (stack.is((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get())) {
            return BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_stripped.png");
        }
        return BeachpartyIdentifier.identifier("textures/models/armor/rubber_ring_blue.png");
    }
}

