/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.neoforge;

import dev.architectury.platform.hooks.EventBusesHooks;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.InterModComms;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.PlayerSetSpawnEvent;
import net.satisfy.beachparty.Beachparty;
import net.satisfy.beachparty.core.block.BeachSunLounger;
import net.satisfy.beachparty.core.block.BeachTowelBlock;
import net.satisfy.beachparty.core.registry.CompostablesRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.neoforge.client.integration.CuriosWearableTrinket;
import net.satisfy.beachparty.neoforge.core.config.BeachpartyNeoForgeConfig;
import net.satisfy.beachparty.neoforge.core.registry.BeachpartyVillagers;
import net.satisfy.beachparty.platform.neoforge.PlatformHelperImpl;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

@Mod(value="beachparty")
public class BeachpartyNeoForge {
    public BeachpartyNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        EventBusesHooks.whenAvailable((String)"beachparty", IEventBus::start);
        BeachpartyVillagers.register(modEventBus);
        PlatformHelperImpl.ENTITY_TYPES.register(modEventBus);
        Beachparty.init();
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BeachpartyNeoForgeConfig.COMMON_CONFIG);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::enqueueIMC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(CompostablesRegistry::init);
        Beachparty.commonSetup();
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.BEACH_HAT.get()), (ICurioItem)new CuriosWearableTrinket.BaseCurio(new Item[0]));
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.SUNGLASSES.get()), (ICurioItem)new CuriosWearableTrinket.BaseCurio(new Item[0]));
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.SWIM_WINGS.get()), (ICurioItem)new CuriosWearableTrinket.SwimWingsCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.BIKINI.get()), (ICurioItem)new CuriosWearableTrinket.SwimSuitCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.TRUNKS.get()), (ICurioItem)new CuriosWearableTrinket.SwimSuitCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_BLUE.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_PINK.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_PELICAN.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.RUBBER_RING_AXOLOTL.get()), (ICurioItem)new CuriosWearableTrinket.RubberRingCurio());
        CuriosApi.registerCurio((Item)((Item)ObjectRegistry.CROCS.get()), (ICurioItem)new CuriosWearableTrinket.CrocsCurio());
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("feet").size(1).icon(ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots")).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HANDS.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getLevel().getBlockState(event.getPos());
        if (state.getBlock() == ObjectRegistry.RADIO.get()) {
            event.setCanceled(true);
        }
    }

    @EventBusSubscriber(modid="beachparty")
    public static class ForgeEventsHandler {
        @SubscribeEvent
        public static void playerSetSpawn(PlayerSetSpawnEvent event) {
            Level level = event.getEntity().level();
            if (event.getNewSpawn() != null) {
                Block block = level.getBlockState(event.getNewSpawn()).getBlock();
                if (!level.isClientSide && (block instanceof BeachTowelBlock || block instanceof BeachSunLounger) && !event.isForced()) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

