/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.platform.PlatformHelper;
import org.joml.Vector3d;

public class MessageInABottleSpawner {
    private static BlockPos lastValidSpawn = null;
    private static long lastSpawnTime = 0L;

    private static void attemptSpawn(ServerLevel level, int maxCount) {
        int z;
        int x;
        BlockPos pos;
        if (level.players().isEmpty()) {
            return;
        }
        RandomSource random = level.random;
        ServerPlayer player = (ServerPlayer)level.players().get(random.nextInt(level.players().size()));
        if (lastValidSpawn == null || level.getGameTime() - lastSpawnTime > 12000L) {
            lastValidSpawn = MessageInABottleSpawner.findValidSpawnPos(level, player.blockPosition());
            lastSpawnTime = level.getGameTime();
        }
        if (lastValidSpawn == null) {
            return;
        }
        int spawnX = lastValidSpawn.getX();
        int spawnY = lastValidSpawn.getY();
        int spawnZ = lastValidSpawn.getZ();
        int count = 0;
        for (int i = 0; !(i >= 200 || level.hasChunkAt(pos = new BlockPos(x = spawnX - 50 + random.nextInt(101), spawnY, z = spawnZ - 50 + random.nextInt(101))) && level.getBlockState(pos).getBlock() == ObjectRegistry.MESSAGE_IN_A_BOTTLE.get() && ++count >= maxCount); ++i) {
        }
        if (count >= maxCount) {
            return;
        }
        BlockState state = ((Block)ObjectRegistry.MESSAGE_IN_A_BOTTLE.get()).defaultBlockState();
        Vector3d vec = new Vector3d((double)lastValidSpawn.getX() + 0.5, (double)lastValidSpawn.getY(), (double)lastValidSpawn.getZ() + 0.5);
        BlockPos placePos = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
        if (!level.hasChunkAt(placePos)) {
            return;
        }
        if (level.isEmptyBlock(placePos) && level.getBlockState(placePos.below()).is(BlockTags.SAND)) {
            level.setBlock(placePos, state, 3);
        }
    }

    private static BlockPos findValidSpawnPos(ServerLevel level, BlockPos center) {
        RandomSource random = level.random;
        for (int i = 0; i < 10; ++i) {
            int offsetZ;
            int offsetX = random.nextInt(200) - 100;
            BlockPos newPos = center.offset(offsetX, 0, offsetZ = random.nextInt(200) - 100);
            Holder biome = level.getBiome(newPos);
            if (!biome.is(BiomeTags.IS_BEACH)) continue;
            int spawnY = level.getHeight(Heightmap.Types.WORLD_SURFACE, newPos.getX(), newPos.getZ()) - 2;
            return new BlockPos(newPos.getX(), spawnY, newPos.getZ());
        }
        return null;
    }

    public static void tick(ServerLevel level) {
        if (!PlatformHelper.allowBottleSpawning()) {
            return;
        }
        int interval = PlatformHelper.getBottleSpawnInterval();
        int maxCount = PlatformHelper.getBottleMaxCount();
        if (level.getGameTime() % (long)interval == 0L) {
            MessageInABottleSpawner.attemptSpawn(level, maxCount);
        }
    }
}

