/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.compat.rei.category;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.satisfy.beachparty.core.compat.rei.display.MiniFridgeDisplay;
import net.satisfy.beachparty.core.registry.ObjectRegistry;

public class MiniFridgeCategory
implements DisplayCategory<MiniFridgeDisplay> {
    public static final CategoryIdentifier<MiniFridgeDisplay> MINE_FRIDGE_DISPLAY = CategoryIdentifier.of((String)"beachparty", (String)"mini_fridge_display");

    public CategoryIdentifier<MiniFridgeDisplay> getCategoryIdentifier() {
        return MINE_FRIDGE_DISPLAY;
    }

    public Component getTitle() {
        return ((Block)ObjectRegistry.MINI_FRIDGE.get()).getName();
    }

    public Renderer getIcon() {
        return EntryStacks.of((ItemLike)((ItemLike)ObjectRegistry.MINI_FRIDGE.get()));
    }

    public int getDisplayWidth(MiniFridgeDisplay display) {
        return 128;
    }

    public int getDisplayHeight() {
        return 64;
    }

    public List<Widget> setupDisplay(MiniFridgeDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - this.getDisplayWidth(display) / 2 - 4, bounds.getCenterY() - this.getDisplayHeight() / 2 + 14);
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase((Rectangle)bounds));
        widgets.add(Widgets.createArrow((Point)new Point(startPoint.x + 54, startPoint.y + 9)).animationDurationTicks(50.0));
        widgets.add(Widgets.createResultSlotBackground((Point)new Point(startPoint.x + 88, startPoint.y + 9)));
        widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 88, startPoint.y + 9)).entries((Collection)display.getOutputEntries().get(0)).disableBackground().markOutput());
        if (display.getInputEntries().isEmpty()) {
            widgets.add(Widgets.createSlotBackground((Point)new Point(startPoint.x + 32, startPoint.y + 9)));
        } else {
            widgets.add(Widgets.createSlot((Point)new Point(startPoint.x + 32, startPoint.y + 9)).entries((Collection)display.getInputEntries().get(0)).markInput());
        }
        return widgets;
    }
}

