/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.satisfy.beachparty.core.registry.EntityTypeRegistry;
import net.satisfy.beachparty.core.registry.ObjectRegistry;
import net.satisfy.beachparty.core.registry.SoundEventRegistry;

public class RadioBlockEntity
extends BlockEntity {
    private static final List<ResourceKey<JukeboxSong>> TRACKS = SoundEventRegistry.RADIO_SONGS;
    private int currentIndex = -1;
    private int ticks;
    private long tickCount;
    private long startTick;
    public boolean isPlaying;
    private boolean syncedWithClient = false;

    public RadioBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EntityTypeRegistry.RADIO_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, RadioBlockEntity entity) {
        if (!entity.isPlaying || !(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (!entity.syncedWithClient) {
            entity.resendSoundToClient(server);
            entity.syncedWithClient = true;
        }
        ++entity.ticks;
        ++entity.tickCount;
        if (server.getGameTime() >= entity.startTick + 1200L) {
            entity.stop();
            return;
        }
        if (level.getRandom().nextFloat() < 0.05f) {
            double baseX = (double)pos.getX() + 0.5;
            double baseY = (double)pos.getY() + 1.0;
            double baseZ = (double)pos.getZ() + 0.5;
            double offsetX = (level.getRandom().nextDouble() - 0.5) * 0.6;
            double offsetZ = (level.getRandom().nextDouble() - 0.5) * 0.6;
            float color = level.getRandom().nextFloat();
            server.sendParticles((ParticleOptions)ParticleTypes.NOTE, baseX + offsetX, baseY, baseZ + offsetZ, 0, (double)color, 0.0, 0.0, 1.0);
        }
    }

    public boolean toggleOrNext() {
        if (!this.isPlaying) {
            this.start();
        } else {
            this.next(this.level);
        }
        return true;
    }

    public void start() {
        this.currentIndex = 0;
        this.play(this.level);
    }

    public void next(Level level) {
        this.currentIndex = (this.currentIndex + 1) % TRACKS.size();
        this.play(level);
    }

    public void stop() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        server.levelEvent(1011, this.worldPosition, 0);
        server.gameEvent((Holder)GameEvent.JUKEBOX_STOP_PLAY, this.worldPosition, GameEvent.Context.of((BlockState)this.getBlockState()));
        this.isPlaying = false;
        this.ticks = 0;
        this.tickCount = 0L;
        this.syncedWithClient = false;
    }

    private void play(Level level) {
        this.stop();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        if (this.currentIndex < 0 || this.currentIndex >= TRACKS.size()) {
            return;
        }
        this.isPlaying = true;
        this.ticks = 0;
        this.startTick = server.getGameTime();
        Item recordItem = this.getRecordItemForCurrentTrack();
        int id = Item.getId((Item)recordItem);
        server.levelEvent(null, 1010, this.worldPosition, id);
        server.gameEvent((Holder)GameEvent.JUKEBOX_PLAY, this.worldPosition, GameEvent.Context.of((BlockState)this.getBlockState()));
        this.syncedWithClient = true;
    }

    private void resendSoundToClient(ServerLevel server) {
        Item recordItem = this.getRecordItemForCurrentTrack();
        int id = Item.getId((Item)recordItem);
        server.levelEvent(null, 1010, this.worldPosition, id);
    }

    private Item getRecordItemForCurrentTrack() {
        return switch (this.currentIndex) {
            case 0 -> (Item)ObjectRegistry.MUSIC_DISC_BEACHPARTY.get();
            case 1 -> (Item)ObjectRegistry.MUSIC_DISC_CARIBBEAN_BEACH.get();
            case 2 -> (Item)ObjectRegistry.MUSIC_DISC_PRIDELANDS.get();
            case 3 -> (Item)ObjectRegistry.MUSIC_DISC_VOCALISTA.get();
            case 4 -> (Item)ObjectRegistry.MUSIC_DISC_WILD_VEINS.get();
            default -> (Item)ObjectRegistry.OVERGROWN_DISC.get();
        };
    }

    protected void loadAdditional(CompoundTag compoundTag, HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
        this.currentIndex = compoundTag.getInt("CurrentIndex");
        this.ticks = compoundTag.getInt("Ticks");
        this.tickCount = compoundTag.getLong("TickCount");
        this.startTick = compoundTag.getLong("StartTick");
        this.isPlaying = compoundTag.getBoolean("IsPlaying");
        this.syncedWithClient = false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        tag.putInt("CurrentIndex", this.currentIndex);
        tag.putInt("Ticks", this.ticks);
        tag.putLong("TickCount", this.tickCount);
        tag.putLong("StartTick", this.startTick);
        tag.putBoolean("IsPlaying", this.isPlaying);
    }
}

