/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.satisfy.beachparty.core.util.BeachpartyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineConnectingBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<BeachpartyUtil.LineConnectingType> TYPE = BeachpartyUtil.LINE_CONNECTING_TYPE;

    public LineConnectingBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(TYPE, (Comparable)((Object)BeachpartyUtil.LineConnectingType.NONE)));
    }

    @NotNull
    public InteractionResult use(BlockState arg, Level arg2, BlockPos arg3, Player arg4, InteractionHand arg5, BlockHitResult arg6) {
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        BlockState blockState = (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
        Level world = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        return switch (facing) {
            case Direction.EAST -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.south()), world.getBlockState(clickedPos.north()))));
            case Direction.SOUTH -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.west()), world.getBlockState(clickedPos.east()))));
            case Direction.WEST -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.north()), world.getBlockState(clickedPos.south()))));
            default -> (BlockState)blockState.setValue(TYPE, (Comparable)((Object)this.getType(blockState, world.getBlockState(clickedPos.east()), world.getBlockState(clickedPos.west()))));
        };
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        if (world.isClientSide) {
            return;
        }
        Direction facing = (Direction)state.getValue((Property)FACING);
        BeachpartyUtil.LineConnectingType type = switch (facing) {
            case Direction.EAST -> this.getType(state, world.getBlockState(pos.south()), world.getBlockState(pos.north()));
            case Direction.SOUTH -> this.getType(state, world.getBlockState(pos.west()), world.getBlockState(pos.east()));
            case Direction.WEST -> this.getType(state, world.getBlockState(pos.north()), world.getBlockState(pos.south()));
            default -> this.getType(state, world.getBlockState(pos.east()), world.getBlockState(pos.west()));
        };
        if (state.getValue(TYPE) != type) {
            state = (BlockState)state.setValue(TYPE, (Comparable)((Object)type));
        }
        world.setBlock(pos, state, 3);
    }

    public BeachpartyUtil.LineConnectingType getType(BlockState state, BlockState left, BlockState right) {
        if (left.getBlock() == Blocks.AIR || right.getBlock() == Blocks.AIR) {
            return BeachpartyUtil.LineConnectingType.NONE;
        }
        boolean shape_left_same = this.isConnectable(left, state);
        boolean shape_right_same = this.isConnectable(right, state);
        if (shape_left_same && shape_right_same) {
            return BeachpartyUtil.LineConnectingType.MIDDLE;
        }
        if (shape_left_same) {
            return BeachpartyUtil.LineConnectingType.LEFT;
        }
        if (shape_right_same) {
            return BeachpartyUtil.LineConnectingType.RIGHT;
        }
        return BeachpartyUtil.LineConnectingType.NONE;
    }

    protected boolean isConnectable(BlockState state1, BlockState state2) {
        return state1.getBlock() == state2.getBlock() && state1.getValue((Property)FACING) == state2.getValue((Property)FACING);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, TYPE});
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

