/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.beachparty.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.vehicle.Boat;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.beachparty.core.util.BeachpartyIdentifier;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class FloatyBoatModel
extends ListModel<Boat>
implements WaterPatchModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(BeachpartyIdentifier.identifier("floaty_boat"), "main");
    private static final String LEFT_PADDLE = "left_paddle";
    private static final String RIGHT_PADDLE = "right_paddle";
    private static final String WATER_PATCH = "water_patch";
    private static final String BOTTOM = "bottom";
    private static final String BACK = "back";
    private static final String FRONT = "front";
    private static final String RIGHT = "right";
    private static final String LEFT = "left";
    private final ModelPart leftPaddle;
    private final ModelPart rightPaddle;
    private final ModelPart waterPatch;
    private final ImmutableList<ModelPart> parts;

    public FloatyBoatModel(ModelPart modelPart) {
        this.leftPaddle = modelPart.getChild(LEFT_PADDLE);
        this.rightPaddle = modelPart.getChild(RIGHT_PADDLE);
        this.waterPatch = modelPart.getChild(WATER_PATCH);
        this.parts = this.createPartsBuilder(modelPart).build();
    }

    protected ImmutableList.Builder<ModelPart> createPartsBuilder(ModelPart modelPart) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object[])new ModelPart[]{modelPart.getChild(BOTTOM), modelPart.getChild(BACK), modelPart.getChild(FRONT), modelPart.getChild(RIGHT), modelPart.getChild(LEFT), this.leftPaddle, this.rightPaddle});
        return builder;
    }

    public static void createChildren(PartDefinition partDefinition) {
        partDefinition.addOrReplaceChild(BOTTOM, CubeListBuilder.create().texOffs(0, 0).mirror().addBox(-14.0f, -7.0f, -17.0f, 28.0f, 16.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)6.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        partDefinition.addOrReplaceChild(FRONT, CubeListBuilder.create().texOffs(0, 29).mirror().addBox(-8.0f, 14.0f, -3.0f, 14.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        partDefinition.addOrReplaceChild(BACK, CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-6.0f, 14.0f, -3.0f, 14.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-15.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        partDefinition.addOrReplaceChild(RIGHT, CubeListBuilder.create().texOffs(0, 39).mirror().addBox(-14.0f, 14.0f, -3.0f, 28.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-9.0f, (float)0.0f, (float)-3.1416f, (float)0.0f));
        partDefinition.addOrReplaceChild(LEFT, CubeListBuilder.create().texOffs(0, 49).mirror().addBox(-14.0f, 14.0f, -1.0f, 28.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)0.0f, (float)9.0f));
        partDefinition.addOrReplaceChild(LEFT_PADDLE, CubeListBuilder.create().texOffs(62, 0).addBox(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).addBox(-1.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.offsetAndRotation((float)3.0f, (float)-5.0f, (float)9.0f, (float)0.0f, (float)0.0f, (float)0.19634955f));
        partDefinition.addOrReplaceChild(RIGHT_PADDLE, CubeListBuilder.create().texOffs(62, 0).addBox(-1.0f, 0.0f, -5.0f, 2.0f, 2.0f, 18.0f).addBox(0.001f, -3.0f, 8.0f, 1.0f, 6.0f, 7.0f), PartPose.offsetAndRotation((float)3.0f, (float)-5.0f, (float)-9.0f, (float)0.0f, (float)((float)Math.PI), (float)0.19634955f));
        partDefinition.addOrReplaceChild(WATER_PATCH, CubeListBuilder.create().texOffs(0, 0).addBox(-14.0f, -9.0f, -3.0f, 28.0f, 16.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)1.0f, (float)1.5707964f, (float)0.0f, (float)0.0f));
    }

    public static LayerDefinition createBodyModel() {
        MeshDefinition meshDefinition = new MeshDefinition();
        PartDefinition partDefinition = meshDefinition.getRoot();
        FloatyBoatModel.createChildren(partDefinition);
        return LayerDefinition.create((MeshDefinition)meshDefinition, (int)128, (int)64);
    }

    public void setupAnim(Boat boat, float f, float g, float h, float i, float j) {
        FloatyBoatModel.animatePaddle(boat, 0, this.leftPaddle, f);
        FloatyBoatModel.animatePaddle(boat, 1, this.rightPaddle, f);
    }

    @NotNull
    public ImmutableList<ModelPart> parts() {
        return this.parts;
    }

    @NotNull
    public ModelPart waterPatch() {
        return this.waterPatch;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0f, -1.1f, 0.0f);
        for (ModelPart part : this.parts) {
            if (part == this.leftPaddle || part == this.rightPaddle) continue;
            part.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        }
        poseStack.popPose();
        this.leftPaddle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
        this.rightPaddle.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }

    private static void animatePaddle(Boat boat, int i, ModelPart modelPart, float f) {
        float g = boat.getRowingTime(i, f);
        modelPart.xRot = Mth.clampedLerp((float)-1.0471976f, (float)-0.2617994f, (float)((Mth.sin((float)g) + 1.0f) / 2.0f));
        modelPart.yRot = Mth.clampedLerp((float)-0.7853982f, (float)0.7853982f, (float)((Mth.sin((float)(g + 1.0f)) + 1.0f) / 2.0f));
        if (i == 1) {
            modelPart.yRot = (float)Math.PI - modelPart.yRot;
        }
    }
}

