/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.camera.film.properties;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.mortuusars.exposure.util.Codecs;
import io.github.mortuusars.exposure.world.camera.film.properties.ColorBalance;
import io.github.mortuusars.exposure.world.camera.film.properties.HSB;
import io.github.mortuusars.exposure.world.camera.film.properties.Levels;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record FilmStyle(Float sensitivity, Float contrast, Levels levels, HSB hsb, ColorBalance colorBalance, Float noise) {
    public static final Codec<FilmStyle> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codecs.floatRange(-10.0f, 10.0f).optionalFieldOf("sensitivity", (Object)Float.valueOf(0.0f)).forGetter(FilmStyle::sensitivity), (App)Codecs.floatRange(-1.0f, 1.0f).optionalFieldOf("contrast", (Object)Float.valueOf(0.0f)).forGetter(FilmStyle::contrast), (App)Levels.CODEC.optionalFieldOf("levels", (Object)Levels.EMPTY).forGetter(FilmStyle::levels), (App)HSB.CODEC.optionalFieldOf("hsb", (Object)HSB.EMPTY).forGetter(FilmStyle::hsb), (App)ColorBalance.CODEC.optionalFieldOf("color_balance", (Object)ColorBalance.EMPTY).forGetter(FilmStyle::colorBalance), (App)Codecs.floatRange(0.0f, 1.0f).optionalFieldOf("noise", (Object)Float.valueOf(0.0f)).forGetter(FilmStyle::noise)).apply((Applicative)instance, FilmStyle::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FilmStyle> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, FilmStyle>(){

        @NotNull
        public FilmStyle decode(RegistryFriendlyByteBuf buffer) {
            return new FilmStyle((Float)ByteBufCodecs.FLOAT.decode((Object)buffer), (Float)ByteBufCodecs.FLOAT.decode((Object)buffer), (Levels)Levels.STREAM_CODEC.decode((Object)buffer), (HSB)HSB.STREAM_CODEC.decode((Object)buffer), (ColorBalance)ColorBalance.STREAM_CODEC.decode((Object)buffer), (Float)ByteBufCodecs.FLOAT.decode((Object)buffer));
        }

        public void encode(RegistryFriendlyByteBuf buffer, FilmStyle data) {
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)data.sensitivity);
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)data.contrast);
            Levels.STREAM_CODEC.encode((Object)buffer, (Object)data.levels);
            HSB.STREAM_CODEC.encode((Object)buffer, (Object)data.hsb);
            ColorBalance.STREAM_CODEC.encode((Object)buffer, (Object)data.colorBalance);
            ByteBufCodecs.FLOAT.encode((Object)buffer, (Object)data.noise);
        }
    };
    public static final FilmStyle EMPTY = new FilmStyle(Float.valueOf(0.0f), Float.valueOf(0.0f), Levels.EMPTY, HSB.EMPTY, ColorBalance.EMPTY, Float.valueOf(0.0f));

    public FilmStyle {
        Preconditions.checkArgument((sensitivity.floatValue() >= -10.0f && sensitivity.floatValue() <= 10.0f ? 1 : 0) != 0, (Object)("sensitivity must be >=-10 and <= 10. Got: " + sensitivity));
        Preconditions.checkArgument((contrast.floatValue() >= -1.0f && contrast.floatValue() <= 1.0f ? 1 : 0) != 0, (Object)("contrast must be >=-1 and <= 1. Got: " + contrast));
        Preconditions.checkArgument((noise.floatValue() >= 0.0f && noise.floatValue() <= 1.0f ? 1 : 0) != 0, (Object)("noise must be >=0 and <=1. Got: " + noise));
    }

    public static FilmStyle create() {
        return EMPTY;
    }

    public FilmStyle withSensitivity(@Nullable Float sensitivity) {
        return new FilmStyle(sensitivity, this.contrast, this.levels, this.hsb, this.colorBalance, this.noise);
    }

    public FilmStyle withContrast(@Nullable Float contrast) {
        return new FilmStyle(this.sensitivity, contrast, this.levels, this.hsb, this.colorBalance, this.noise);
    }

    public FilmStyle withLevels(@Nullable Levels levels) {
        return new FilmStyle(this.sensitivity, this.contrast, levels, this.hsb, this.colorBalance, this.noise);
    }

    public FilmStyle withHSB(@Nullable HSB hsb) {
        return new FilmStyle(this.sensitivity, this.contrast, this.levels, hsb, this.colorBalance, this.noise);
    }

    public FilmStyle withColorBalance(@Nullable ColorBalance colorBalance) {
        return new FilmStyle(this.sensitivity, this.contrast, this.levels, this.hsb, colorBalance, this.noise);
    }

    public FilmStyle withNoise(@Nullable Float noise) {
        return new FilmStyle(this.sensitivity, this.contrast, this.levels, this.hsb, this.colorBalance, noise);
    }
}

