/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.util;

import io.github.mortuusars.exposure.util.Vec3Util;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public record PointOfView(Vec3 pos, Vec3 dir) {
    public static PointOfView of(CameraHolder holder) {
        return PointOfView.of(holder.asHolderEntity());
    }

    public static PointOfView of(Entity entity) {
        return new PointOfView(entity.position().add(0.0, (double)entity.getEyeHeight(), 0.0), Vec3.directionFromRotation((float)Mth.clamp((float)entity.getXRot(), (float)-89.0f, (float)89.0f), (float)entity.getYRot()));
    }

    public PointOfView rotateX(double degrees) {
        Vec3 upVector = new Vec3(0.0, 1.0, 0.0);
        Vec3 rightVector = this.dir.cross(upVector).normalize();
        if (Mth.equal((double)rightVector.length(), (double)0.0)) {
            rightVector = new Vec3(1.0, 0.0, 0.0).cross(this.dir).normalize();
        }
        Vec3 rotated = Vec3Util.rotateVector(this.dir(), rightVector, Math.toRadians(degrees));
        return new PointOfView(this.pos, rotated);
    }

    public PointOfView rotateY(double degrees) {
        return new PointOfView(this.pos, this.dir.yRot((float)Math.toRadians(degrees)));
    }

    public PointOfView move(double x, double y, double z) {
        return new PointOfView(this.pos.add(x, y, z), this.dir);
    }

    public PointOfView reverseDirection() {
        return new PointOfView(this.pos, this.dir.reverse());
    }

    public PointOfView limitMaxDistance(CameraHolder holder, double distance) {
        return this.limitMaxDistance(holder.asHolderEntity(), distance);
    }

    public PointOfView limitMaxDistance(Entity entity, double distance) {
        float maxDistance = this.getMaxCameraDistance(entity, this.pos, this.dir, (float)distance);
        return new PointOfView(this.pos.add(this.dir.normalize().scale((double)(-maxDistance))), this.dir);
    }

    private float getMaxCameraDistance(Entity entity, Vec3 position, Vec3 direction, float maxDistance) {
        for (int i = 0; i < 8; ++i) {
            float distanceSqr;
            float xOff = (i & 1) * 2 - 1;
            float yOff = (i >> 1 & 1) * 2 - 1;
            float zOff = (i >> 2 & 1) * 2 - 1;
            Vec3 pos = position.add((double)(xOff * 0.1f), (double)(yOff * 0.1f), (double)(zOff * 0.1f));
            Vec3 endPos = pos.add(direction.scale((double)(-maxDistance)));
            BlockHitResult hitResult = entity.level().clip(new ClipContext(pos, endPos, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.of((Entity)entity)));
            if (hitResult.getType() == HitResult.Type.MISS || !((distanceSqr = (float)hitResult.getLocation().distanceToSqr(position)) < Mth.square((float)maxDistance))) continue;
            maxDistance = Mth.sqrt((float)distanceSqr);
        }
        return maxDistance;
    }
}

