/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.mixin.client;

import com.mojang.authlib.GameProfile;
import io.github.mortuusars.exposure.client.camera.CameraClient;
import io.github.mortuusars.exposure.world.camera.Camera;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends Player {
    public LocalPlayerMixin(Level level, BlockPos pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    public void setActiveExposureCamera(Camera camera) {
        super.setActiveExposureCamera(camera);
        CameraClient.setupViewfinder(camera);
    }

    public void removeActiveExposureCamera() {
        super.removeActiveExposureCamera();
        CameraClient.removeViewfinder();
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo ci) {
        CameraClient.tick();
        this.getActiveExposureCameraOptional().ifPresent(camera -> {
            if (!camera.isActive()) {
                this.removeActiveExposureCamera();
            }
        });
    }
}

