/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.album;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.gui.screen.album.AlbumGUI;
import io.github.mortuusars.exposure.client.gui.screen.album.ChildPhotographScreen;
import io.github.mortuusars.exposure.client.gui.screen.album.PhotographSlotWidget;
import io.github.mortuusars.exposure.client.gui.screen.element.Pager;
import io.github.mortuusars.exposure.client.gui.screen.element.TextBlock;
import io.github.mortuusars.exposure.client.gui.screen.element.textbox.HorizontalAlignment;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBinding;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.util.Side;
import io.github.mortuusars.exposure.world.item.PhotographItem;
import io.github.mortuusars.exposure.world.item.component.album.AlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.AlbumPage;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumContent;
import io.github.mortuusars.exposure.world.item.component.album.SignedAlbumPage;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AlbumViewScreen
extends Screen {
    protected final Pager pager = new Pager().setChangeSound(new SoundEffect(() -> SoundEvents.BOOK_PAGE_TURN)).onPageChanged(this::onSpreadChanged);
    protected final KeyBindings keyBindings;
    protected final List<Page> pages;
    protected AlbumAccess albumAccess;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;

    public AlbumViewScreen(AlbumAccess albumAccess) {
        super((Component)Component.empty());
        KeyBinding[] keyBindingArray = new KeyBinding[5];
        keyBindingArray[0] = Key.press(Minecrft.options().keyInventory).executes(() -> ((AlbumViewScreen)this).onClose());
        keyBindingArray[1] = Key.press(263).or(Key.press(65)).executes(this.pager::previousPage);
        keyBindingArray[2] = Key.press(262).or(Key.press(68)).executes(this.pager::nextPage);
        keyBindingArray[3] = Key.release(263).or(Key.press(65)).executes(this.pager::resetCooldown);
        keyBindingArray[4] = Key.release(262).or(Key.press(68)).executes(this.pager::resetCooldown);
        this.keyBindings = KeyBindings.of(keyBindingArray);
        this.pages = new ArrayList<Page>();
        this.albumAccess = albumAccess;
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        this.imageWidth = 298;
        this.imageHeight = 188;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.pages.clear();
        Page leftPage = this.createPage(Side.LEFT, 0);
        this.pages.add(leftPage);
        ImageButton previousPageButton = new ImageButton(this.leftPos + 12, this.topPos + 164, 13, 15, AlbumGUI.PREVIOUS_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.PREVIOUS), (Component)Component.translatable((String)"gui.exposure.previous_page"));
        previousPageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure.previous_page")));
        this.addRenderableWidget((GuiEventListener)previousPageButton);
        Page rightPage = this.createPage(Side.RIGHT, 140);
        this.pages.add(rightPage);
        ImageButton nextPageButton = new ImageButton(this.leftPos + 273, this.topPos + 164, 13, 15, AlbumGUI.NEXT_PAGE_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.NEXT), (Component)Component.translatable((String)"gui.exposure.next_page"));
        nextPageButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.exposure.next_page")));
        this.addRenderableWidget((GuiEventListener)nextPageButton);
        int spreadsCount = (int)Math.ceil((float)this.albumAccess.pages().size() / 2.0f);
        this.pager.setPagesCount(spreadsCount).setPreviousPageButton((AbstractButton)previousPageButton).setNextPageButton((AbstractButton)nextPageButton);
    }

    protected Page createPage(Side side, int xOffset) {
        int x = this.leftPos + xOffset;
        int y = this.topPos;
        PhotographSlotWidget photographWidget = new PhotographSlotWidget(this, x + 25, y + 21, 108, 108, () -> this.getPage(side).orElse(PageContent.EMPTY).photograph()).editable(false).primaryAction(widget -> this.inspectPhotograph(widget.getPhotograph()));
        this.addRenderableWidget((GuiEventListener)photographWidget);
        TextBlock noteWidget = new TextBlock(this.font, x + 22, y + 133, 114, 27, this.getPage(side).orElse(PageContent.EMPTY).note(), this::handleComponentClicked);
        noteWidget.fontColor = Config.getColor(Config.Client.ALBUM_FONT_MAIN_COLOR);
        noteWidget.alignment = HorizontalAlignment.CENTER;
        noteWidget.drawShadow = false;
        return new Page(side, photographWidget, noteWidget);
    }

    public List<PageContent> getPages() {
        return this.albumAccess.pages();
    }

    public Optional<PageContent> getPage(int pageIndex) {
        if (pageIndex <= this.getPages().size() - 1) {
            return Optional.ofNullable(this.getPages().get(pageIndex));
        }
        return Optional.empty();
    }

    public Optional<PageContent> getPage(Side side) {
        return this.getPage(this.getCurrentSpreadIndex() * 2 + side.getIndex());
    }

    public int getCurrentSpreadIndex() {
        return this.pager.getPage();
    }

    protected void onSpreadChanged(int oldSpread, int newSpread) {
        this.forEachPage(page -> {
            Component note = this.getPage(page.side).orElse(PageContent.EMPTY).note();
            page.noteWidget().setMessage(note);
        });
    }

    public void setAlbumAccess(AlbumAccess albumAccess) {
        this.albumAccess = albumAccess;
        this.pager.setPagesCount(albumAccess.getPageCount() / 2);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        for (Page page : this.pages) {
            TextBlock noteWidget = page.noteWidget();
            if (!(noteWidget instanceof TextBlock)) continue;
            TextBlock textBlock = noteWidget;
            textBlock.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        for (Page page : this.pages) {
            if (!page.photographWidget().isHoveredOrFocused()) continue;
            page.photographWidget().renderTooltip(guiGraphics, x, y);
            return;
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(AlbumGUI.TEXTURE, this.leftPos, this.topPos, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        int currentSpreadIndex = this.getCurrentSpreadIndex();
        this.drawPageNumbers(guiGraphics, currentSpreadIndex, mouseX, mouseY);
    }

    protected void drawPageNumbers(GuiGraphics guiGraphics, int currentSpreadIndex, int mouseX, int mouseY) {
        Font font = Minecrft.get().font;
        String leftPageNumber = Integer.toString(currentSpreadIndex * 2 + 1);
        String rightPageNumber = Integer.toString(currentSpreadIndex * 2 + 2);
        guiGraphics.drawString(font, leftPageNumber, this.leftPos + 71 + (8 - font.width(leftPageNumber) / 2), this.topPos + 167, Config.getColor(Config.Client.ALBUM_FONT_SECONDARY_COLOR), false);
        guiGraphics.drawString(font, rightPageNumber, this.leftPos + 212 + (8 - font.width(rightPageNumber) / 2), this.topPos + 167, Config.getColor(Config.Client.ALBUM_FONT_SECONDARY_COLOR), false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        for (Page page : this.pages) {
            if (!page.noteWidget().mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    public boolean handleComponentClicked(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        ClickEvent clickEvent = style.getClickEvent();
        if (clickEvent == null) {
            return false;
        }
        if (clickEvent.getAction() == ClickEvent.Action.CHANGE_PAGE) {
            String pageIndexStr = clickEvent.getValue();
            int pageIndex = Integer.parseInt(pageIndexStr) - 1;
            this.forcePage(pageIndex);
            return true;
        }
        boolean handled = super.handleComponentClicked(style);
        if (handled && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.onClose();
        }
        return handled;
    }

    protected void forcePage(int pageIndex) {
        this.pager.changePage(pageIndex / 2);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.keyReleased(keyCode, scanCode, modifiers);
    }

    protected void inspectPhotograph(ItemStack photograph) {
        if (!(photograph.getItem() instanceof PhotographItem)) {
            return;
        }
        Minecrft.get().setScreen((Screen)new ChildPhotographScreen(this, List.of(new ItemAndStack(photograph))));
        Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), (float)(Minecrft.level().getRandom().nextFloat() * 0.2f + 1.3f), (float)0.75f));
    }

    protected void forEachPage(Consumer<Page> pageAction) {
        for (Page page : this.pages) {
            pageAction.accept(page);
        }
    }

    public record AlbumAccess(List<PageContent> pages) {
        public static final AlbumAccess EMPTY = new AlbumAccess(Collections.emptyList());

        public int getPageCount() {
            return this.pages.size();
        }

        public static AlbumAccess fromItem(ItemStack stack) {
            Object object = stack.get(Exposure.DataComponents.ALBUM_CONTENT);
            if (object instanceof AlbumContent) {
                AlbumContent content = (AlbumContent)object;
                return new AlbumAccess(content.pages().stream().map(PageContent::new).toList());
            }
            object = stack.get(Exposure.DataComponents.SIGNED_ALBUM_CONTENT);
            if (object instanceof SignedAlbumContent) {
                SignedAlbumContent content = (SignedAlbumContent)object;
                return new AlbumAccess(content.pages().stream().map(PageContent::new).toList());
            }
            return EMPTY;
        }
    }

    protected record Page(Side side, PhotographSlotWidget photographWidget, TextBlock noteWidget) {
    }

    public record PageContent(ItemStack photograph, Component note) {
        public static final PageContent EMPTY = new PageContent(ItemStack.EMPTY, (Component)Component.empty());

        public PageContent(AlbumPage page) {
            this(page.photograph(), (Component)Component.literal((String)page.note()));
        }

        public PageContent(SignedAlbumPage page) {
            this(page.photograph(), page.note());
        }
    }
}

