/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.network;

import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.data.SoundboardData;
import dev.lucaargolo.utils.misc.SoundBoard;
import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ServerboundSoundboardPacket(String sound, boolean favorite) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSoundboardPacket> TYPE = new CustomPacketPayload.Type(Utils.id("soundboard_to_server"));
    public static final StreamCodec<ByteBuf, ServerboundSoundboardPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ServerboundSoundboardPacket::sound, (StreamCodec)ByteBufCodecs.BOOL, ServerboundSoundboardPacket::favorite, ServerboundSoundboardPacket::new);

    public static void handleServer(ServerboundSoundboardPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer sender = (ServerPlayer)player;
            if (!sender.hasPermissions(2)) {
                sender.displayClientMessage((Component)Component.literal((String)"You don't have permission to do that.").withStyle(ChatFormatting.RED), true);
                return;
            }
            if (payload.favorite) {
                SoundboardData data = SoundboardData.get(sender.server);
                data.toggleFavoriteSound(sender, payload.sound);
                SoundBoard.updatePlayer(sender);
            } else {
                try {
                    SoundBoard.playSound(sender, payload.sound);
                }
                catch (Exception e) {
                    sender.displayClientMessage((Component)Component.literal((String)"An unknown error happened while trying to play this sound.").withStyle(ChatFormatting.RED), true);
                    Utils.LOGGER.error("[Sound Board] Error while playing sound: ", (Throwable)e);
                }
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

