/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.network;

import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.blockentity.ModBlockEntityTypes;
import dev.lucaargolo.utils.client.misc.HTTPCubeMapHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.Utf8String;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ServerboundSkyConfigPacket(BlockPos pos, HTTPCubeMapHandler.CubeMap.Format format, String[] links, float scale) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSkyConfigPacket> TYPE = new CustomPacketPayload.Type(Utils.id("sky_config"));
    public static final StreamCodec<ByteBuf, String[]> ARRAY_CODEC = new StreamCodec<ByteBuf, String[]>(){

        public String @NotNull [] decode(ByteBuf buffer) {
            int length = buffer.readInt();
            String[] data = new String[length];
            for (int i = 0; i < length; ++i) {
                data[i] = Utf8String.read((ByteBuf)buffer, (int)Short.MAX_VALUE);
            }
            return data;
        }

        public void encode(ByteBuf buffer, String[] value) {
            buffer.writeInt(value.length);
            for (String s : value) {
                Utf8String.write((ByteBuf)buffer, (CharSequence)s, (int)Short.MAX_VALUE);
            }
        }
    };
    public static final StreamCodec<ByteBuf, ServerboundSkyConfigPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, ServerboundSkyConfigPacket::pos, HTTPCubeMapHandler.CubeMap.Format.STREAM_CODEC, ServerboundSkyConfigPacket::format, ARRAY_CODEC, ServerboundSkyConfigPacket::links, (StreamCodec)ByteBufCodecs.FLOAT, ServerboundSkyConfigPacket::scale, ServerboundSkyConfigPacket::new);

    public static void handleServer(ServerboundSkyConfigPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player player = context.player();
            if (player.isCreative()) {
                Level level = player.level();
                BlockPos pos = payload.pos();
                BlockState state = level.getBlockState(pos);
                level.getBlockEntity(payload.pos, (BlockEntityType)ModBlockEntityTypes.SKY.get()).ifPresent(be -> {
                    be.setFormat(payload.format);
                    be.setLinks(payload.links);
                    be.setScale(payload.scale);
                    level.sendBlockUpdated(pos, state, state, 3);
                });
            }
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

