/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.network;

import dev.lucaargolo.utils.Arkanis;
import dev.lucaargolo.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetSubtitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.network.protocol.game.ClientboundSetTitlesAnimationPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ServerboundSendTitlePacket(String title, String subtitle, int fadeIn, int stay, int fadeOut, boolean allPlayers, List<String> playerNames) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundSendTitlePacket> TYPE = new CustomPacketPayload.Type(Utils.id("send_title"));
    public static final StreamCodec<ByteBuf, ServerboundSendTitlePacket> STREAM_CODEC = new StreamCodec<ByteBuf, ServerboundSendTitlePacket>(){

        @NotNull
        public ServerboundSendTitlePacket decode(@NotNull ByteBuf buffer) {
            String title = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            String subtitle = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buffer);
            int fadeIn = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            int stay = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            int fadeOut = (Integer)ByteBufCodecs.INT.decode((Object)buffer);
            boolean allPlayers = (Boolean)ByteBufCodecs.BOOL.decode((Object)buffer);
            List playerNames = (List)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8).decode((Object)buffer);
            return new ServerboundSendTitlePacket(title, subtitle, fadeIn, stay, fadeOut, allPlayers, playerNames);
        }

        public void encode(@NotNull ByteBuf buffer, @NotNull ServerboundSendTitlePacket packet) {
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)packet.title);
            ByteBufCodecs.STRING_UTF8.encode((Object)buffer, (Object)packet.subtitle);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)packet.fadeIn);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)packet.stay);
            ByteBufCodecs.INT.encode((Object)buffer, (Object)packet.fadeOut);
            ByteBufCodecs.BOOL.encode((Object)buffer, (Object)packet.allPlayers);
            ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8).encode((Object)buffer, new ArrayList<String>(packet.playerNames));
        }
    };

    public static void handleServer(ServerboundSendTitlePacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                if (!sender.hasPermissions(2)) {
                    Arkanis.sendMessage(sender, "Voc\u00ea n\u00e3o tem permiss\u00e3o para usar este comando!", ChatFormatting.RED);
                    return;
                }
                MinecraftServer server = sender.getServer();
                if (server == null) {
                    return;
                }
                MutableComponent titleComponent = Component.literal((String)payload.title.replace("&", "\u00a7"));
                MutableComponent subtitleComponent = Component.literal((String)payload.subtitle.replace("&", "\u00a7"));
                if (payload.allPlayers) {
                    for (ServerPlayer player : server.getPlayerList().getPlayers()) {
                        ServerboundSendTitlePacket.sendTitleToPlayer(player, (Component)titleComponent, (Component)subtitleComponent, payload.fadeIn, payload.stay, payload.fadeOut);
                    }
                    Arkanis.sendMessage(sender, "T\u00edtulo enviado para todos os jogadores!", ChatFormatting.GREEN);
                } else {
                    int sentCount = 0;
                    for (String playerName : payload.playerNames) {
                        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(playerName);
                        if (targetPlayer != null) {
                            ServerboundSendTitlePacket.sendTitleToPlayer(targetPlayer, (Component)titleComponent, (Component)subtitleComponent, payload.fadeIn, payload.stay, payload.fadeOut);
                            ++sentCount;
                            continue;
                        }
                        Arkanis.sendMessage(sender, "Jogador n\u00e3o encontrado: " + playerName, ChatFormatting.YELLOW);
                    }
                    if (sentCount > 0) {
                        Arkanis.sendMessage(sender, "T\u00edtulo enviado para " + sentCount + " jogador(es)!", ChatFormatting.GREEN);
                    }
                }
            }
        });
    }

    private static void sendTitleToPlayer(ServerPlayer player, Component title, Component subtitle, int fadeIn, int stay, int fadeOut) {
        player.connection.send((Packet)new ClientboundSetTitlesAnimationPacket(fadeIn, stay, fadeOut));
        player.connection.send((Packet)new ClientboundSetSubtitleTextPacket(subtitle));
        player.connection.send((Packet)new ClientboundSetTitleTextPacket(title));
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

