/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.network;

import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.data.ModDataComponentTypes;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.LecternMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ServerboundBookImagesPacket(int slot, ListTag imagesList) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerboundBookImagesPacket> TYPE = new CustomPacketPayload.Type(Utils.id("book_images"));
    public static final StreamCodec<ByteBuf, ServerboundBookImagesPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ServerboundBookImagesPacket::slot, ModDataComponentTypes.LIST_TAG_STREAM_CODEC, ServerboundBookImagesPacket::imagesList, ServerboundBookImagesPacket::new);

    public static void handleServer(ServerboundBookImagesPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ItemStack itemstack;
            Player sender = context.player();
            int i = payload.slot;
            AbstractContainerMenu patt0$temp = sender.containerMenu;
            if (patt0$temp instanceof LecternMenu) {
                LecternMenu menu = (LecternMenu)patt0$temp;
                itemstack = menu.getBook();
                if (itemstack.is(Items.WRITABLE_BOOK)) {
                    itemstack.set(ModDataComponentTypes.BOOK_IMAGES, (Object)payload.imagesList);
                }
            } else if ((Inventory.isHotbarSlot((int)i) || i == 40) && (itemstack = sender.getInventory().getItem(i)).is(Items.WRITABLE_BOOK)) {
                itemstack.set(ModDataComponentTypes.BOOK_IMAGES, (Object)payload.imagesList);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

