/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.network;

import dev.lucaargolo.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ClientboundSoundboardPacket(int serverSeparatorChar, Map<String, Object> availableSounds, List<String> playingSounds, List<String> favoriteSounds) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundSoundboardPacket> TYPE = new CustomPacketPayload.Type(Utils.id("soundboard_to_client"));
    public static final StreamCodec<ByteBuf, Map<String, Object>> SOUND_MAP_CODEC = new StreamCodec<ByteBuf, Map<String, Object>>(){

        @NotNull
        public Map<String, Object> decode(@NotNull ByteBuf buf) {
            return this.decode(buf, new LinkedHashMap<String, Object>());
        }

        public Map<String, Object> decode(ByteBuf buf, Map<String, Object> map) {
            int size = buf.readInt();
            for (int i = 0; i < size; ++i) {
                String name = (String)ByteBufCodecs.STRING_UTF8.decode((Object)buf);
                boolean folder = buf.readBoolean();
                if (folder) {
                    Map<String, Object> innerMap = this.decode(buf, new HashMap<String, Object>());
                    map.put(name, innerMap);
                    continue;
                }
                map.put(name, name);
            }
            return map;
        }

        public void encode(@NotNull ByteBuf buf, @NotNull Map<String, Object> map) {
            buf.writeInt(map.size());
            map.forEach((name, object) -> {
                ByteBufCodecs.STRING_UTF8.encode((Object)buf, name);
                if (object instanceof Map) {
                    Map innerMap = (Map)object;
                    buf.writeBoolean(true);
                    this.encode(buf, innerMap);
                } else {
                    buf.writeBoolean(false);
                }
            });
        }
    };
    public static final StreamCodec<ByteBuf, ClientboundSoundboardPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ClientboundSoundboardPacket::serverSeparatorChar, SOUND_MAP_CODEC, ClientboundSoundboardPacket::availableSounds, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), ClientboundSoundboardPacket::playingSounds, (StreamCodec)ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.STRING_UTF8), ClientboundSoundboardPacket::favoriteSounds, ClientboundSoundboardPacket::new);

    public static void handleClient(ClientboundSoundboardPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Utils.PROXY.setServerSeparatorChar((char)payload.serverSeparatorChar);
            Utils.PROXY.setAvailableSounds(payload.availableSounds);
            Utils.PROXY.setPlayingSounds(payload.playingSounds);
            Utils.PROXY.setFavoriteSounds(payload.favoriteSounds);
        });
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

