/*
 * Decompiled with CFR 0.152.
 */
package dev.lucaargolo.utils.network;

import dev.lucaargolo.utils.Utils;
import dev.lucaargolo.utils.data.ColorfulSkyData;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ClientboundColorfulSkyPacket(boolean active, float red, float green, float blue, float near, float far) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ClientboundColorfulSkyPacket> TYPE = new CustomPacketPayload.Type(Utils.id("colorful_sky"));
    public static final StreamCodec<ByteBuf, ClientboundColorfulSkyPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, ClientboundColorfulSkyPacket::active, (StreamCodec)ByteBufCodecs.FLOAT, ClientboundColorfulSkyPacket::red, (StreamCodec)ByteBufCodecs.FLOAT, ClientboundColorfulSkyPacket::green, (StreamCodec)ByteBufCodecs.FLOAT, ClientboundColorfulSkyPacket::blue, (StreamCodec)ByteBufCodecs.FLOAT, ClientboundColorfulSkyPacket::near, (StreamCodec)ByteBufCodecs.FLOAT, ClientboundColorfulSkyPacket::far, ClientboundColorfulSkyPacket::new);

    public static void handleClient(ClientboundColorfulSkyPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ColorfulSkyData data = Utils.PROXY.getColorfulSky();
            if (payload.active) {
                data.setColorfulSky(payload.red, payload.green, payload.blue, payload.near, payload.far);
            } else {
                data.setColorfulSky(false);
            }
        });
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

